/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.space;

import com.eclipsesource.json.JsonObject;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.CreateRepositoryRequestDialog;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.IKieSpaceHandler;
import org.kie.eclipse.server.KieRepositoryHandler;

public class CreateRepositoryAction
extends KieNavigatorAction {
    protected CreateRepositoryAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public CreateRepositoryAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Create Repository...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieSpaceHandler space = (IKieSpaceHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        CreateRepositoryRequestDialog dlg = new CreateRepositoryRequestDialog(Display.getDefault().getActiveShell(), space);
        if (dlg.open() == 0) {
            JsonObject properties = dlg.getResult();
            String name = properties.get("name").asString().trim();
            KieRepositoryHandler repository = new KieRepositoryHandler(space, name);
            repository.setProperties(properties);
            try {
                delegate.createRepository((IKieRepositoryHandler)repository);
                CreateRepositoryAction.refreshViewer(container);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

