/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyBehavior
extends ElementEditor {
    protected static final String[] childNames = new String[]{"omit", "keepalive"};
    public static String[] fgNamesOmit = new String[]{"omit"};
    public static String[] fgNamesKeepAlive = new String[]{"keepalive"};

    public PropertyBehavior(Element root) throws MalformedElementException {
        super(root, "propertybehavior");
    }

    public void addProperty(String propertyHref) {
        Assert.isNotNull(propertyHref);
        Assert.isTrue(ElementEditor.getFirstChild(this.root, "omit") == null);
        Element keepalive = ElementEditor.getFirstChild(this.root, "keepalive");
        if (keepalive == null) {
            keepalive = ElementEditor.addChild(this.root, "keepalive", fgNamesKeepAlive, true);
        } else {
            Assert.isTrue(!"*".equals(ElementEditor.getFirstText(keepalive)));
        }
        ElementEditor.addChild(keepalive, "href", ElementEditor.encodeHref(propertyHref), new String[]{"href"}, false);
    }

    public static PropertyBehavior create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = ElementEditor.create(document, "propertybehavior");
        PropertyBehavior result = null;
        try {
            result = new PropertyBehavior(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Enumeration getProperties() throws MalformedElementException {
        Element keepalive = ElementEditor.getFirstChild(this.root, "keepalive");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingKeealiveElmt"), keepalive);
        ElementEditor.ensure(!"*".equals(ElementEditor.getFirstText(keepalive)), Policy.bind("ensure.wrongForm"));
        Element firstHref = ElementEditor.getFirstChild(keepalive, "href");
        ElementEditor.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), firstHref);
        Enumeration e = new Enumeration(firstHref){
            Element currentHref;
            {
                this.currentHref = element;
            }

            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String href = ElementEditor.getFirstText(this.currentHref);
                this.currentHref = ElementEditor.getTwin(this.currentHref, true);
                return ElementEditor.decodeHref(href);
            }
        };
        return e;
    }

    public boolean isKeepAllAlive() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), child);
        boolean isKeepAllAlive = false;
        if (ElementEditor.isDAVElement(child, "keepalive")) {
            isKeepAllAlive = "*".equals(ElementEditor.getFirstText(child));
            ElementEditor.ensureNull(Policy.bind("ensure.conflictingHrefElmt"), ElementEditor.getFirstChild(child, "href"));
        }
        child = ElementEditor.getNextSibling(child, childNames);
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), child);
        return isKeepAllAlive;
    }

    public boolean isOmit() throws MalformedElementException {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        ElementEditor.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), child);
        boolean isOmit = ElementEditor.isDAVElement(child, "omit");
        child = ElementEditor.getNextSibling(child, childNames);
        ElementEditor.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), child);
        return isOmit;
    }

    public void setIsKeepAllAlive(boolean isKeepAllAlive) {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        boolean isAlreadyKeepAllAlive = false;
        if (ElementEditor.isDAVElement(child, "keepalive")) {
            isAlreadyKeepAllAlive = "*".equals(ElementEditor.getFirstText(child));
        }
        if (isKeepAllAlive) {
            if (!isAlreadyKeepAllAlive) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                ElementEditor.appendChild(this.root, "keepalive", "*");
            }
        } else if (isAlreadyKeepAllAlive) {
            this.root.removeChild(child);
        }
    }

    public void setIsOmit(boolean isOmit) {
        Element child = ElementEditor.getFirstChild(this.root, childNames);
        boolean isAlreadyOmit = ElementEditor.isDAVElement(child, "omit");
        if (isOmit) {
            if (!isAlreadyOmit) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                ElementEditor.appendChild(this.root, "omit");
            }
        } else if (isAlreadyOmit) {
            this.root.removeChild(child);
        }
    }
}

