/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import org.eclipse.webdav.internal.kernel.Policy;

public class DAVRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 510L;
    private Throwable fWrappedException = null;
    private int fErrorCode = 0;

    public DAVRuntimeException(int code, String message) {
        super(message);
        this.setErrorCode(code);
    }

    public DAVRuntimeException(String message) {
        super(message);
    }

    public DAVRuntimeException(Throwable exception) {
        if (exception instanceof DAVRuntimeException) {
            this.setWrappedException(((DAVRuntimeException)exception).getWrappedException());
        } else {
            this.setWrappedException(exception);
        }
    }

    public DAVRuntimeException(Throwable exception, String message) {
        super(String.valueOf(message) + "\n " + Policy.bind("label.exceptionMessage") + exception.getMessage());
        this.setWrappedException(exception);
    }

    public int getErrorCode() {
        if (this.getWrappedException() != null && this.getWrappedException() instanceof DAVRuntimeException) {
            return ((DAVRuntimeException)this.getWrappedException()).getErrorCode();
        }
        return this.fErrorCode;
    }

    public Throwable getWrappedException() {
        return this.fWrappedException;
    }

    public void printStackTrace() {
        Throwable wrappedException = this.getWrappedException();
        if (wrappedException != null) {
            wrappedException.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    protected void setErrorCode(int errorCode) {
        this.fErrorCode = errorCode;
    }

    protected void setWrappedException(Throwable exception) {
        this.fWrappedException = exception;
    }
}

