/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.LockEntry;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SupportedLock
extends Property {
    protected static final String[] childNames = new String[]{"lockentry"};

    public SupportedLock(Element root) throws MalformedElementException {
        super(root, "supportedlock");
    }

    public LockEntry addLockEntry() {
        Element lockentry = SupportedLock.addChild(this.root, "lockentry", childNames, false);
        Element locktype = SupportedLock.appendChild(lockentry, "locktype");
        SupportedLock.appendChild(locktype, "write");
        LockEntry result = null;
        try {
            result = new LockEntry(lockentry);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Enumeration getLockEntries() throws MalformedElementException {
        Element firstLockEntry = SupportedLock.getFirstChild(this.root, "lockentry");
        Enumeration e = new Enumeration(firstLockEntry){
            Node currentLockEntry;
            {
                this.currentLockEntry = node;
            }

            public boolean hasMoreElements() {
                return this.currentLockEntry != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                LockEntry result = null;
                try {
                    result = new LockEntry((Element)this.currentLockEntry);
                }
                catch (MalformedElementException malformedElementException) {
                    Assert.isTrue(false, Policy.bind("assert.internalError"));
                }
                this.currentLockEntry = SupportedLock.getTwin((Element)this.currentLockEntry, true);
                return result;
            }
        };
        return e;
    }
}

