/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.authentication.AuthenticateChallenge;
import org.eclipse.webdav.internal.authentication.AuthorizationAuthority;
import org.eclipse.webdav.internal.authentication.Base64Encoder;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class BasicAuthority
extends AuthorizationAuthority {
    public BasicAuthority(IAuthenticator authenticationStore) {
        super(authenticationStore);
    }

    private String credentials(String username, String password) {
        Assert.isNotNull(username);
        Assert.isNotNull(password);
        String userpass = String.valueOf(username) + ":" + password;
        byte[] data = null;
        try {
            data = userpass.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            data = userpass.getBytes();
        }
        return "Basic " + Base64Encoder.encode(data);
    }

    protected Map getAuthenticationInfo(AuthenticateChallenge challenge, Map oldInfo, URL serverUrl, URL protectionSpaceUrl) {
        Assert.isNotNull(challenge);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        return this.authenticatorStore.requestAuthenticationInfo(protectionSpaceUrl, challenge.getRealm(), challenge.getAuthScheme());
    }

    protected String getAuthorization(Request request, Map info, URL serverUrl, URL protectionSpaceUrl, URL proxyServerUrl) {
        Assert.isNotNull(request);
        Assert.isNotNull(info);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        String username = (String)info.get("username");
        String password = (String)info.get("password");
        if (username == null || password == null) {
            return null;
        }
        return this.credentials(username, password);
    }
}

