/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime {
    protected SimpleDateFormat dateFormat;
    protected long dateTime;
    protected static final String RFC_1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    protected static final String RFC_850_PATTERN = "E, dd-MMM-yyyy HH:mm:ss 'GMT'";
    protected static final String ASCTIME_PATTERN = "EEE MMM dd HH:mm:ss yyyy";
    protected static final String ISO_8601_UTC_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    protected static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssz";
    protected static final String ISO_8601_UTC_MILLIS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String ISO_8601_MILLIS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSz";

    public DateTime() {
        this(0L);
    }

    public DateTime(long date) {
        this.setDateTime(date);
        this.dateFormat = new SimpleDateFormat();
        this.dateFormat.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US));
    }

    public boolean after(DateTime other) {
        return this.getDateTime() > other.getDateTime();
    }

    public boolean before(DateTime other) {
        return this.getDateTime() < other.getDateTime();
    }

    public boolean equals(DateTime other) {
        return this.getDateTime() == other.getDateTime();
    }

    public long getDateTime() {
        return this.dateTime;
    }

    public int getMilliseconds() {
        return (int)(this.getDateTime() % 1000L);
    }

    public void setDateTime(long dateTime) {
        this.dateTime = dateTime;
    }

    public void setDateTime(String date) {
        String[] patterns = new String[]{RFC_1123_PATTERN, ISO_8601_UTC_PATTERN, ISO_8601_UTC_MILLIS_PATTERN, ISO_8601_PATTERN, ISO_8601_MILLIS_PATTERN, RFC_850_PATTERN, ASCTIME_PATTERN};
        int i = 0;
        while (i < patterns.length) {
            if (this.setDateTime(date, patterns[i])) break;
            ++i;
        }
    }

    protected boolean setDateTime(String date, String pattern) {
        boolean dateChanged = true;
        this.dateFormat.applyPattern(pattern);
        try {
            this.setDateTime(this.dateFormat.parse(date));
        }
        catch (ParseException parseException) {
            dateChanged = false;
        }
        return dateChanged;
    }

    public void setDateTime(Date date) {
        this.dateTime = date.getTime();
    }

    public Date toDate() {
        return new Date(this.dateTime);
    }

    public String toISO8601() {
        if (this.getMilliseconds() == 0) {
            return this.toString(ISO_8601_UTC_PATTERN);
        }
        return this.toString(ISO_8601_UTC_MILLIS_PATTERN);
    }

    public String toRFC1123() {
        return this.toString(RFC_1123_PATTERN);
    }

    public String toString() {
        return this.toRFC1123();
    }

    protected String toString(String pattern) {
        this.dateFormat.applyPattern(pattern);
        return this.dateFormat.format(this.toDate());
    }
}

