/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.MalformedElementException;

public class Status {
    private int fStatusCode;
    private String fStatusMessage;

    public Status(String status) throws MalformedElementException {
        status = status.trim();
        int len = status.length();
        int start = 0;
        while (start < len && !Character.isWhitespace(status.charAt(start))) {
            ++start;
        }
        while (start < len && Character.isWhitespace(status.charAt(start))) {
            ++start;
        }
        if (start >= len) {
            throw new MalformedElementException(Policy.bind("exception.malformedStatus", status));
        }
        int end = start;
        while (end < len && Character.isDigit(status.charAt(end))) {
            ++end;
        }
        if (end == start || end >= len) {
            throw new MalformedElementException(Policy.bind("exception.malformedStatus", status));
        }
        this.fStatusCode = Integer.parseInt(status.substring(start, end));
        start = end;
        while (start < len && Character.isWhitespace(status.charAt(start))) {
            ++start;
        }
        if (start >= len) {
            throw new MalformedElementException(Policy.bind("exception.malformedStatus", status));
        }
        this.fStatusMessage = status.substring(start, len);
    }

    public int getStatusCode() {
        return this.fStatusCode;
    }

    public String getStatusMessage() {
        return this.fStatusMessage;
    }
}

