/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.tools.as.wst.server.ui.xpl.ServerToolTip;
import org.kie.eclipse.navigator.KieNavigatorContentRoot;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.ServerNode;

public class KieNavigatorContentProvider
implements ITreeContentProvider {
    static final Object PENDING = new Object();
    private ConcurrentMap<IContainerNode<?>, Object> pendingUpdates = new ConcurrentHashMap();
    private transient TreeViewer viewer;
    private Job loadElementJob = new Job(Messages.ServerContent_Job_Title){

        public boolean shouldRun() {
            return KieNavigatorContentProvider.this.pendingUpdates.size() > 0;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ServerContent_Job_Title, -1);
            try {
                final ArrayList<IContainerNode> updatedNodes = new ArrayList<IContainerNode>(KieNavigatorContentProvider.this.pendingUpdates.size());
                for (IContainerNode node : KieNavigatorContentProvider.this.pendingUpdates.keySet()) {
                    try {
                        node.load();
                        updatedNodes.add(node);
                    }
                    catch (Exception exception) {}
                    if (!monitor.isCanceled()) continue;
                    KieNavigatorContentProvider.this.pendingUpdates.keySet().removeAll(updatedNodes);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                final TreeViewer viewer = KieNavigatorContentProvider.this.viewer;
                if (viewer == null) {
                    KieNavigatorContentProvider.this.pendingUpdates.keySet().clear();
                } else {
                    viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (viewer.getTree().isDisposed()) {
                                return;
                            }
                            for (IContainerNode node : updatedNodes) {
                                KieNavigatorContentProvider.this.pendingUpdates.remove(node);
                                viewer.refresh((Object)node);
                            }
                        }
                    });
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    };
    private ServerToolTip tooltip = null;
    List<ServerNode> rootElements;

    public void dispose() {
        this.viewer = null;
        this.loadElementJob.cancel();
        this.pendingUpdates.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        } else {
            viewer = null;
        }
        if (this.tooltip != null) {
            this.tooltip.deactivate();
        }
        this.tooltip = new ServerToolTip(((TreeViewer)viewer).getTree()){

            protected boolean isMyType(Object selected) {
                return selected instanceof ServerNode;
            }

            protected void fillStyledText(Composite parent, StyledText sText, Object o) {
                sText.setText("View JBoss-7 management details.");
            }
        };
        this.tooltip.setShift(new Point(15, 8));
        this.tooltip.setPopupDelay(500);
        this.tooltip.setHideOnMouseDown(true);
        this.tooltip.activate();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<? extends Object> results = new ArrayList<Object>();
        if (parentElement instanceof KieNavigatorContentRoot) {
            List<? extends Object> children = ((KieNavigatorContentRoot)parentElement).getChildren();
            results.addAll(children);
        } else if (parentElement instanceof IContainerNode) {
            IContainerNode container = (IContainerNode)parentElement;
            if (this.pendingUpdates.containsKey(container)) {
                return new Object[]{PENDING};
            }
            List<Object> children = container.getChildren();
            if (children == null) {
                this.pendingUpdates.putIfAbsent(container, PENDING);
                this.loadElementJob.schedule();
                return new Object[]{PENDING};
            }
            for (Object node : children) {
                if (node instanceof IContentNode) {
                    node = ((IContentNode)node).resolveContent();
                }
                results.add(node);
            }
        }
        return results.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IContentNode) {
            Object parent = ((IContentNode)element).getContainer();
            if (parent == null) {
                parent = ((IContentNode)element).getServer();
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return true;
        }
        if (element instanceof IContainerNode) {
            return ((IContainerNode)element).hasChildren();
        }
        return false;
    }
}

