/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.KieNavigatorContentProvider;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.IErrorNode;
import org.kie.eclipse.navigator.view.content.OrganizationNode;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.navigator.view.content.ServerNode;

public class KieNavigatorLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof IContainerNode) {
            return ((IContainerNode)element).getName();
        }
        if (element instanceof IContentNode) {
            return ((IContentNode)element).getName();
        }
        if (element instanceof IErrorNode) {
            return ((IErrorNode)element).getText();
        }
        if (element == KieNavigatorContentProvider.PENDING) {
            return "Loading...";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ServerNode) {
            if (((ServerNode)element).getServer().getServerState() == 2) {
                return Activator.getImageDescriptor("server_started.gif").createImage();
            }
            return Activator.getImageDescriptor("server_stopped.gif").createImage();
        }
        if (element instanceof OrganizationNode) {
            return Activator.getImageDescriptor("organization.gif").createImage();
        }
        if (element instanceof RepositoryNode) {
            if (((RepositoryNode)element).isResolved()) {
                return Activator.getImageDescriptor("repository.gif").createImage();
            }
            return Activator.getImageDescriptor("repository_unavailable.gif").createImage();
        }
        if (element instanceof ProjectNode) {
            if (((ProjectNode)element).isResolved()) {
                return Activator.getImageDescriptor("project.gif").createImage();
            }
            return Activator.getImageDescriptor("project_closed.gif").createImage();
        }
        if (element instanceof IContainerNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IErrorNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof IContentNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return super.getImage(element);
    }
}

