/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.CreateProjectRequestDialog;
import org.kie.eclipse.navigator.view.content.ContentNode;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.navigator.view.utils.ActionUtils;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieProjectHandler;
import org.kie.eclipse.server.KieRepositoryHandler;

public class CreateProjectAction
extends KieNavigatorAction {
    protected CreateProjectAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public CreateProjectAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Create Project...");
    }

    public String getToolTipText() {
        return "Create a new Project";
    }

    public boolean isEnabled() {
        KieRepositoryHandler handler;
        IContainerNode<?> container = this.getContainer();
        return !(container instanceof ContentNode) || (handler = (KieRepositoryHandler)((ContentNode)((Object)container)).getHandler()) != null && handler.isLoaded();
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieRepositoryHandler repository = (IKieRepositoryHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        CreateProjectRequestDialog dlg = new CreateProjectRequestDialog(this.getShell(), repository);
        if (dlg.open() == 0) {
            JsonObject properties = dlg.getResult();
            String name = properties.get("name").asString();
            KieProjectHandler project = new KieProjectHandler(repository, name);
            project.setProperties(properties);
            try {
                delegate.createProject((IKieProjectHandler)project);
                container.clearChildren();
                container.getNavigator().getCommonViewer().refresh(container);
                ContentNode projectNode = null;
                if (dlg.shouldImportProject()) {
                    container.load();
                    for (Object child : container.getChildren()) {
                        if (!(child instanceof ProjectNode) || !project.getName().equals(((ProjectNode)child).getName())) continue;
                        projectNode = (ProjectNode)child;
                        break;
                    }
                    if (projectNode == null) {
                        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("The Project '" + project.getName() + "' is not found!"));
                        return;
                    }
                    IJavaProject javaProject = ActionUtils.importProject(projectNode, this);
                    if (javaProject != null && dlg.shouldCreateArtifacts()) {
                        String artifactId = dlg.getArtifactId();
                        JsonObject projectProperties = projectNode.getHandler().getProperties();
                        JsonValue jv = projectProperties.get("groupId");
                        String groupId = null;
                        if ((jv == null || jv.asString().isEmpty()) && projectNode.getParent() instanceof RepositoryNode) {
                            JsonObject orgProperties = projectNode.getParent().getParent().getHandler().getProperties();
                            jv = orgProperties.get("defaultGroupId");
                        }
                        if (jv != null) {
                            groupId = jv.asString();
                        }
                        String version = null;
                        jv = projectProperties.get("version");
                        if (jv != null) {
                            version = jv.asString();
                        }
                        ActionUtils.createProjectArtifacts(javaProject, groupId, artifactId, version, null);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

