/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.server.IKieResourceHandler;

public abstract class ContentNode<T extends IContainerNode<?>>
implements IContentNode<T> {
    protected IKieResourceHandler handler;
    protected IContainerNode<?> parent;
    protected T container;
    protected final String name;

    protected ContentNode(String name) {
        this.parent = null;
        this.container = null;
        this.name = name;
    }

    protected ContentNode(T container, IKieResourceHandler handler) {
        this.parent = container instanceof IContainerNode ? container : (container == null ? null : container.getParent());
        this.container = container;
        this.name = handler.getName();
        this.handler = handler;
    }

    @Override
    public IContainerNode<?> getParent() {
        return this.parent;
    }

    @Override
    public T getContainer() {
        return this.container;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IServer getServer() {
        return this.getRoot().getServer();
    }

    @Override
    public CommonNavigator getNavigator() {
        return this.getRoot().getNavigator();
    }

    @Override
    public IContainerNode<?> getRoot() {
        if (this.parent == null) {
            return (IContainerNode)((Object)this);
        }
        return this.parent.getRoot();
    }

    public String getRuntimeId() {
        return this.getRoot().getRuntimeId();
    }

    @Override
    public void dispose() {
        this.container = null;
        this.parent = null;
        if (this.handler != null) {
            this.handler.dispose();
            this.handler = null;
        }
    }

    @Override
    public IKieResourceHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean isResolved() {
        return this.getHandler().isLoaded();
    }

    @Override
    public Object resolveContent() {
        this.getHandler().load();
        return this;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IKieResourceHandler.class) {
            return this.getHandler();
        }
        return null;
    }

    public abstract boolean equals(Object var1);
}

