/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.utils;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.kie.eclipse.navigator.view.actions.repository.KieCredentialsProvider;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.utils.PreferencesUtils;

public class ActionUtils {
    public static IRuntimeManager runtimeManager = DroolsRuntimeManager.getDefault();

    private ActionUtils() {
    }

    public static void importRepository(final Window.IExceptionHandler exceptionHandler, RepositoryNode container) {
        IKieRepositoryHandler handler = (IKieRepositoryHandler)container.getHandler();
        IKieServerHandler server = (IKieServerHandler)handler.getRoot();
        IKieServiceDelegate delegate = container.getHandler().getDelegate();
        try {
            String host = delegate.getServer().getHost();
            int port = delegate.getGitPort();
            String username = delegate.getUsername();
            String password = delegate.getPassword();
            URIish uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            final String localPath = PreferencesUtils.getRepoPath((IKieRepositoryHandler)handler);
            final String remotePath = uri.toString();
            final KieCredentialsProvider credentialsProvider = new KieCredentialsProvider(server, username, password);
            Job job = new Job("Import Repository"){

                protected IStatus run(IProgressMonitor monitor) {
                    FileRepository localRepo = null;
                    try {
                        try {
                            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer(monitor);
                            localRepo = new FileRepository(String.valueOf(localPath) + File.separator + ".git");
                            CloneCommand cloneCmd = (CloneCommand)((CloneCommand)((CloneCommand)Git.cloneRepository().setURI(remotePath).setDirectory(new File(localPath)).setProgressMonitor((ProgressMonitor)gitMonitor).setCloneAllBranches(true).setTimeout(60)).setCredentialsProvider(credentialsProvider)).setTransportConfigCallback(new TransportConfigCallback(){

                                public void configure(Transport transport) {
                                    TransportGitSsh gt = (TransportGitSsh)transport;
                                    gt.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                                        protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
                                            Session session = super.createSession(hc, user, host, port, fs);
                                            session.setConfig("PreferredAuthentications", "password");
                                            return session;
                                        }

                                        protected void configure(OpenSshConfig.Host hc, Session session) {
                                            session.setConfig("PreferredAuthentications", "password");
                                        }
                                    });
                                }
                            });
                            cloneCmd.call();
                            localRepo.close();
                            RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
                            util.addConfiguredRepository(localRepo.getDirectory());
                            localRepo = null;
                        }
                        catch (Exception e) {
                            exceptionHandler.handleException((Throwable)e);
                            if (localRepo != null) {
                                localRepo.close();
                            }
                        }
                    }
                    finally {
                        if (localRepo != null) {
                            localRepo.close();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        catch (Exception e) {
            exceptionHandler.handleException((Throwable)e);
        }
    }

    public static IJavaProject importProject(final ProjectNode projectNode, final Window.IExceptionHandler exceptionHandler) {
        final String projectName = projectNode.getName();
        final AtomicReference ar = new AtomicReference();
        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IJavaProject javaProject = ActionUtils.createOrOpenProject(projectNode, projectName, monitor);
                    if (javaProject != null) {
                        ar.set(javaProject);
                        IProject project = javaProject.getProject();
                        HashMap<IProject, File> projectsToConnect = new HashMap<IProject, File>();
                        RepositoryFinder finder = new RepositoryFinder(project);
                        finder.setFindInChildren(false);
                        Collection mappings = finder.find((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (!mappings.isEmpty()) {
                            RepositoryMapping mapping = (RepositoryMapping)mappings.iterator().next();
                            projectsToConnect.put(project, mapping.getGitDirAbsolutePath().toFile());
                            ConnectProviderOperation connect = new ConnectProviderOperation(projectsToConnect);
                            connect.execute(monitor);
                        }
                    }
                }
                catch (Exception e1) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            exceptionHandler.handleException((Throwable)e1);
                        }
                    });
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wsr, null);
        }
        catch (Exception e) {
            exceptionHandler.handleException((Throwable)e);
        }
        return (IJavaProject)ar.get();
    }

    public static IJavaProject createOrOpenProject(final ProjectNode projectNode, final String projectName, IProgressMonitor monitor) throws CoreException, IllegalArgumentException {
        final AtomicReference ar = new AtomicReference();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        RepositoryNode repoNode = (RepositoryNode)projectNode.getContainer();
        Repository repository = ((KieRepositoryHandler)repoNode.getHandler()).getRepository();
        final IPath location = new Path(repository.getWorkTree().toString()).append(projectName);
        if (project.exists()) {
            IPath oldLocation;
            if (!project.isOpen() && (oldLocation = project.getFile(".project").getLocation()) != null && oldLocation.equals((Object)location)) {
                project.open(monitor);
                project.refreshLocal(2, monitor);
                return null;
            }
            throw new IllegalArgumentException("The Project " + projectName + " already exists");
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    IProjectDescription pd = workspace.newProjectDescription(projectName);
                    pd.setLocation(location);
                    FileUtils.addJavaNature((IProjectDescription)pd);
                    FileUtils.addMavenNature((IProjectDescription)pd);
                    project.create(pd, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    IRuntime runtime = runtimeManager.getEffectiveRuntime(null, true);
                    runtimeManager.setRuntime(runtime, project, monitor);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    FileUtils.createOutputLocation((IJavaProject)javaProject, (String)"bin", (IProgressMonitor)monitor);
                    FileUtils.addJavaBuilder((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    FileUtils.addMavenBuilder((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    runtimeManager.addBuilder(javaProject, monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/java", (boolean)true, (IProgressMonitor)monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/resources", (boolean)true, (IProgressMonitor)monitor);
                    FileUtils.addFolderToClasspath((IJavaProject)javaProject, (String)"src/main/rules", (boolean)true, (IProgressMonitor)monitor);
                    ar.set(javaProject);
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF", (IProgressMonitor)monitor);
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF/maven", (IProgressMonitor)monitor);
                    JsonObject projectProperties = projectNode.getHandler().getProperties();
                    JsonValue jv = projectProperties.get("groupId");
                    String groupId = null;
                    if ((jv == null || jv.asString().isEmpty()) && projectNode.getParent() instanceof RepositoryNode) {
                        JsonObject orgProperties = projectNode.getParent().getParent().getHandler().getProperties();
                        jv = orgProperties.get("defaultGroupId");
                    }
                    if (jv != null) {
                        groupId = jv.asString();
                    }
                    String artifactId = null;
                    jv = projectProperties.get("artifactId");
                    if (jv != null) {
                        artifactId = jv.asString();
                    }
                    String version = null;
                    jv = projectProperties.get("version");
                    if (jv != null) {
                        version = jv.asString();
                    }
                    FileUtils.createMavenArtifacts((IJavaProject)javaProject, (String)groupId, (String)artifactId, (String)version, (IProgressMonitor)monitor);
                    FileUtils.createKJarArtifacts((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    project.build(6, monitor);
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Problem creating new project", (String)e.getMessage(), null);
                }
            }
        };
        try {
            op.run(monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (IJavaProject)ar.get();
    }

    public static void createProjectArtifacts(final IJavaProject javaProject, final String groupId, final String artifactId, final String version, IProgressMonitor monitor) throws CoreException, IllegalArgumentException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF", (IProgressMonitor)monitor);
                    FileUtils.createFolder((IJavaProject)javaProject, (String)"src/main/resources/META-INF/maven", (IProgressMonitor)monitor);
                    FileUtils.createMavenArtifacts((IJavaProject)javaProject, (String)groupId, (String)artifactId, (String)version, (IProgressMonitor)monitor);
                    FileUtils.createKJarArtifacts((IJavaProject)javaProject, (IProgressMonitor)monitor);
                    javaProject.getProject().build(6, monitor);
                }
                catch (Exception e) {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Problem creating project artifacts", (String)e.getMessage(), null);
                }
            }
        };
        try {
            op.run(monitor);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

