/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.actions.dialogs.AbstractKieRequestDialog;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestChangeListener;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestValidator;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogTextField;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;

public class CreateProjectRequestDialog
extends AbstractKieRequestDialog {
    private static final String DESCRIPTION = "description";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GROUP_ID = "groupId";
    private static final String VERSION = "version";
    IKieRepositoryHandler repository;
    KieRequestDialogTextField name;
    KieRequestDialogTextField description;
    KieRequestDialogTextField groupId;
    KieRequestDialogTextField artifactId;
    KieRequestDialogTextField version;
    String artifactIdValue = null;
    boolean importProject = true;
    boolean createArtifacts = true;

    public CreateProjectRequestDialog(Shell shell, final IKieRepositoryHandler repository) {
        super(shell, "Project", new IKieRequestValidator(){

            @Override
            public String isValid(JsonObject object) {
                String name;
                JsonValue jv = object.get("name");
                String string = name = jv == null ? null : jv.asString();
                if (name != null && !name.isEmpty()) {
                    try {
                        for (IKieProjectHandler p : repository.getProjects()) {
                            if (!p.getName().equals(name)) continue;
                            return "Project '" + name + "' already exists in this Repository";
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    return "Name is required";
                }
                return null;
            }
        });
        this.setTitleImage(Activator.getImage("icons/wizban/project.png"));
        this.repository = repository;
    }

    @Override
    protected void createFields(Composite composite) {
        this.setMessage("Enter the Project details");
        this.name = new KieRequestDialogTextField(composite, "Name:", "", this.properties, "name");
        this.name.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateProjectRequestDialog.this.validate();
            }
        });
        this.description = new KieRequestDialogTextField(composite, "Description:", "", this.properties, DESCRIPTION);
        this.groupId = new KieRequestDialogTextField(composite, "Group ID:", "", this.properties, GROUP_ID);
        this.artifactId = new KieRequestDialogTextField(composite, "Artifact ID:", "", this.properties, ARTIFACT_ID);
        this.version = new KieRequestDialogTextField(composite, "Version:", "", this.properties, VERSION);
        new Label(composite, 0);
        final Button importProjectButton = new Button(composite, 32);
        importProjectButton.setText("Import the Project into my Workspace when done");
        importProjectButton.setSelection(this.importProject);
        new Label(composite, 0);
        new Label(composite, 0);
        final Button createArtifactsButton = new Button(composite, 32);
        createArtifactsButton.setText("Create Maven and KJar artifacts");
        createArtifactsButton.setSelection(this.createArtifacts);
        new Label(composite, 0);
        createArtifactsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateProjectRequestDialog.this.createArtifacts = createArtifactsButton.getSelection();
            }
        });
        importProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateProjectRequestDialog.this.importProject = importProjectButton.getSelection();
                createArtifactsButton.setEnabled(CreateProjectRequestDialog.this.importProject);
            }
        });
    }

    public int open() {
        int rtn = super.open();
        JsonObject object = super.getResult();
        JsonValue jv = object.get(ARTIFACT_ID);
        if (jv != null) {
            this.artifactIdValue = jv.asString();
        }
        object.remove(ARTIFACT_ID);
        return rtn;
    }

    public boolean shouldImportProject() {
        return this.importProject;
    }

    public boolean shouldCreateArtifacts() {
        return this.createArtifacts;
    }

    public String getArtifactId() {
        return this.artifactIdValue;
    }
}

