/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.LoginDialog;
import org.kie.eclipse.navigator.view.actions.repository.KieCredentialsProvider;
import org.kie.eclipse.navigator.view.content.ContentNode;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.utils.PreferencesUtils;

public class SyncRepositoryAction
extends KieNavigatorAction {
    protected SyncRepositoryAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public SyncRepositoryAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Synchronize Repository");
    }

    public boolean isEnabled() {
        IContainerNode<?> container = this.getContainer();
        if (container instanceof ContentNode) {
            KieRepositoryHandler handler = (KieRepositoryHandler)((ContentNode)((Object)container)).getHandler();
            if (handler == null || !handler.isLoaded()) {
                return false;
            }
            Repository repository = handler.getRepository();
            Map allRefs = repository.getAllRefs();
            for (Map.Entry entry : allRefs.entrySet()) {
                Ref cfr_ignored_0 = (Ref)entry.getValue();
            }
        }
        return true;
    }

    public String getToolTipText() {
        return "Synchronize this local Git Repository with the remote server";
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieRepositoryHandler handler = (IKieRepositoryHandler)container.getHandler();
        IKieServerHandler server = (IKieServerHandler)handler.getRoot();
        IKieServiceDelegate delegate = this.getDelegate();
        try {
            String host = delegate.getServer().getHost();
            int port = delegate.getGitPort();
            String username = delegate.getUsername();
            String password = delegate.getPassword();
            URIish uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            LoginDialog dlg = new LoginDialog(this.getShell(), uri);
            dlg.setUsername(username);
            dlg.setPassword(password);
            if (dlg.open() != 0) {
                return;
            }
            username = dlg.getUsername();
            password = dlg.getPassword();
            uri = PreferencesUtils.getRepoURI((String)host, (int)port, (String)username, (String)handler.getName());
            PreferencesUtils.getRepoPath((IKieRepositoryHandler)handler);
            uri.toString();
            new KieCredentialsProvider(server, username, password);
            Job job = new Job("Sync Repository"){

                protected IStatus run(IProgressMonitor monitor) {
                    Object localRepo = null;
                    if (localRepo != null) {
                        localRepo.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

