/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.IKieNavigatorView;
import org.kie.eclipse.navigator.view.content.ContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.OrganizationNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.KieServerHandler;

public class ServerNode
extends ContainerNode
implements IPropertyChangeListener,
IKieConstants {
    protected IKieNavigatorView navigator;
    protected final IServer server;

    public ServerNode(IServer server, IKieNavigatorView navigator) {
        super(server == null ? "root" : server.getName());
        this.server = server;
        this.navigator = navigator;
        this.handler = server == null ? null : new KieServerHandler(server);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    protected List<? extends IContentNode<?>> createChildren() {
        this.clearHandlerChildren();
        this.load();
        ArrayList<OrganizationNode> children = new ArrayList<OrganizationNode>();
        for (IKieResourceHandler h : this.handlerChildren) {
            ContainerNode n = null;
            if (h instanceof IKieOrganizationHandler) {
                n = new OrganizationNode(this, (IKieOrganizationHandler)h);
            } else if (h instanceof IKieRepositoryHandler) {
                n = new RepositoryNode(this, (IKieRepositoryHandler)h);
            }
            if (n == null) continue;
            children.add((OrganizationNode)n);
        }
        return children;
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public IKieNavigatorView getNavigator() {
        return this.navigator;
    }

    @Override
    public IKieResourceHandler getHandler() {
        if (this.handler == null) {
            this.handler = new KieServerHandler(this.server);
        }
        return this.handler;
    }

    @Override
    public String getRuntimeId() {
        return this.getHandler().getRuntimeId();
    }

    @Override
    public boolean isResolved() {
        return this.getServer().getServerState() == 2;
    }

    @Override
    public void dispose() {
        super.dispose();
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServerNode) {
            try {
                ServerNode other = (ServerNode)obj;
                return other.getServer().getId().equals(this.getServer().getId());
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getProperty();
        if (name.endsWith("RepositoryPath") || name.endsWith("UseDefaultGitPath")) {
            this.clearChildren();
            this.navigator.refresh(this);
        }
    }
}

