/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import com.eclipsesource.json.JsonObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.CreateProjectRequestDialog;
import org.kie.eclipse.navigator.view.content.ContentNode;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.ProjectNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.navigator.view.utils.ActionUtils;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieProjectHandler;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.utils.FileUtils;

public class CreateProjectAction
extends KieNavigatorAction {
    protected CreateProjectAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public CreateProjectAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Create Project...");
    }

    public String getToolTipText() {
        return "Create a new Project";
    }

    public boolean isEnabled() {
        KieRepositoryHandler handler;
        IContainerNode<?> container = this.getContainer();
        return !(container instanceof ContentNode) || (handler = (KieRepositoryHandler)((ContentNode)((Object)container)).getHandler()) != null && handler.isLoaded();
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieRepositoryHandler repository = (IKieRepositoryHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        CreateProjectRequestDialog dlg = new CreateProjectRequestDialog(CreateProjectAction.getShell(), repository);
        if (dlg.open() == 0) {
            JsonObject properties = dlg.getResult();
            String name = properties.get("name").asString();
            KieProjectHandler project = new KieProjectHandler(repository, name);
            project.setProperties(properties);
            try {
                delegate.createProject((IKieProjectHandler)project);
                ActionUtils.pullRepository(this, (RepositoryNode)container);
                ProjectNode projectNode = null;
                if (dlg.shouldImportProject()) {
                    container.clearChildren();
                    container.load();
                    for (IContentNode<?> child : container.getChildren()) {
                        if (!(child instanceof ProjectNode) || !project.getName().equals(((ProjectNode)child).getName())) continue;
                        projectNode = (ProjectNode)child;
                        break;
                    }
                    if (projectNode == null) {
                        MessageDialog.openError((Shell)CreateProjectAction.getShell(), (String)"Error", (String)("The Project '" + project.getName() + "' is not found!"));
                        return;
                    }
                    IJavaProject javaProject = ActionUtils.importProject(projectNode, this);
                    if (javaProject != null) {
                        FileUtils.createGitIgnore((IJavaProject)javaProject, null);
                    }
                }
                container.refresh();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

