/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestChangeListener;

public abstract class KieRequestDialogField<TYPE> {
    JsonObject object;
    String name;
    int numColumns;
    IKieRequestChangeListener changeListener;

    public KieRequestDialogField(Composite parent, JsonObject object, String name) {
        this.object = object;
        this.name = name;
        this.numColumns = ((GridLayout)parent.getLayout()).numColumns;
    }

    public void setChangeListener(IKieRequestChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected void updateObject(TYPE value) {
        JsonValue oldValue = this.object.get(this.name);
        JsonValue newValue = JsonValue.valueOf(value);
        if (newValue != null && !newValue.equals((Object)oldValue)) {
            this.object.set(this.name, value);
            if (this.changeListener != null) {
                this.changeListener.objectChanged(this.object);
            }
        }
    }

    protected GridData createLabelGridData() {
        return new GridData(0x1000008, 0x1000000, false, true, 1, 1);
    }

    protected GridData createControlGridData() {
        return new GridData(4, 0x1000000, true, true, this.numColumns - 1, 1);
    }

    protected Label createLabel(Composite parent, String labelValue) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)this.createLabelGridData());
        label.setFont(parent.getFont());
        label.setText(labelValue);
        return label;
    }

    protected Text createText(Composite parent, int style, String textValue) {
        Text text = new Text(parent, style);
        text.setLayoutData((Object)this.createControlGridData());
        text.setFont(parent.getFont());
        text.setText(textValue);
        return text;
    }

    public abstract Control getControl();
}

