/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.server;

import com.eclipsesource.json.JsonObject;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.actions.dialogs.CreateSpaceRequestDialog;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.IKieSpaceHandler;
import org.kie.eclipse.server.KieSpaceHandler;

public class CreateSpaceAction
extends KieNavigatorAction {
    protected CreateSpaceAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public CreateSpaceAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Create Space...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieServerHandler server = (IKieServerHandler)container.getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        CreateSpaceRequestDialog dlg = new CreateSpaceRequestDialog(CreateSpaceAction.getShell(), server);
        if (dlg.open() == 0) {
            JsonObject properties = dlg.getResult();
            String name = properties.get("name").asString().trim();
            KieSpaceHandler space = new KieSpaceHandler(server, name);
            space.setProperties(properties);
            try {
                delegate.createSpace((IKieSpaceHandler)space);
                CreateSpaceAction.refreshViewer(container);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }
}

