/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.Activator;
import org.kie.eclipse.navigator.view.IKieNavigatorView;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IContentNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.navigator.view.content.ServerNode;
import org.kie.eclipse.server.IKieResourceHandler;

public abstract class ContentNode<T extends IContainerNode<?>>
implements IContentNode<T>,
IWorkbenchAdapter {
    protected IKieResourceHandler handler;
    protected IContainerNode<?> parent;
    protected final String name;

    protected ContentNode(String name) {
        this.parent = null;
        this.name = name;
    }

    protected ContentNode(T parent, IKieResourceHandler handler) {
        this.parent = parent;
        this.name = handler.getName();
        this.handler = handler;
    }

    @Override
    public IContainerNode<?> getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IServer getServer() {
        if (this.parent == null) {
            return ((ServerNode)this).server;
        }
        return this.getRoot().getServer();
    }

    @Override
    public IKieNavigatorView getNavigator() {
        try {
            if (this.parent == null) {
                return ((ServerNode)this).navigator;
            }
            return this.getRoot().getNavigator();
        }
        catch (Exception e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public IContainerNode<?> getRoot() {
        if (this.parent == null) {
            return (IContainerNode)((Object)this);
        }
        return this.parent.getRoot();
    }

    public String getRuntimeId() {
        return this.getRoot().getRuntimeId();
    }

    @Override
    public void dispose() {
        if (this.handler != null) {
            this.handler.dispose();
            this.handler = null;
        }
    }

    @Override
    public IKieResourceHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean isResolved() {
        return this.getHandler() != null && this.getHandler().isLoaded();
    }

    @Override
    public Object resolveContent() {
        this.getHandler().load();
        return this;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IKieResourceHandler.class) {
            return this.getHandler();
        }
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IContentNode) {
            try {
                IContentNode other = (IContentNode)obj;
                return other.getName().equals(this.getName());
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof RepositoryNode) {
            if (this instanceof RepositoryNode) {
                return this.getName().compareTo(((RepositoryNode)arg0).getName());
            }
            return 1;
        }
        if (this instanceof RepositoryNode) {
            if (arg0 instanceof RepositoryNode) {
                return this.getName().compareTo(((RepositoryNode)arg0).getName());
            }
            return -1;
        }
        if (arg0 instanceof IContentNode) {
            return this.getName().compareTo(((IContentNode)arg0).getName());
        }
        return 0;
    }

    @Override
    public synchronized void refresh() {
        final IKieNavigatorView navigator = this.getNavigator();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    navigator.setProperty("org.kie.eclipse.navigator.property.internalRefresh", Boolean.toString(true));
                    navigator.refresh(ContentNode.this.getRoot());
                }
                finally {
                    navigator.setProperty("org.kie.eclipse.navigator.property.internalRefresh", Boolean.toString(false));
                }
            }
        });
    }

    protected static Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    @Override
    public void handleException(final Throwable t) {
        t.printStackTrace();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)ContentNode.getShell(), (String)"Error", (String)t.getMessage());
            }
        });
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getName();
    }

    public Object getParent(Object o) {
        return this.getParent();
    }
}

