/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.kie.eclipse.preferences.AbstractRuntimeDialog;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;

public abstract class AbstractRuntimesBlock
implements ISelectionProvider {
    private IRuntimeManager runtimeManager;
    private Composite fControl;
    private List<IRuntime> runtimes = new ArrayList<IRuntime>();
    private CheckboxTableViewer runtimesList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.runtimesList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            if (!this.runtimesList.getTable().isDisposed()) {
                Object runtime = ((IStructuredSelection)selection).getFirstElement();
                if (runtime == null) {
                    this.runtimesList.setCheckedElements(new Object[0]);
                } else {
                    this.runtimesList.setCheckedElements(new Object[]{runtime});
                    this.runtimesList.reveal(runtime);
                }
                this.fireSelectionChanged();
            }
        }
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        this.runtimeManager = this.getRuntimeManager();
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite((Composite)ancestor, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)parent, (String)"Installed Runtimes", (int)2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText("Name");
        int defaultwidth = 176;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText("Location");
        column.setWidth(defaultwidth);
        this.runtimesList = new CheckboxTableViewer(this.fTable);
        this.runtimesList.setLabelProvider((IBaseLabelProvider)new RuntimesLabelProvider());
        this.runtimesList.setContentProvider((IContentProvider)new RuntimesContentProvider());
        this.runtimesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                AbstractRuntimesBlock.this.enableButtons();
            }
        });
        this.runtimesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    AbstractRuntimesBlock.this.setDefaultRuntime((IRuntime)event.getElement());
                } else {
                    AbstractRuntimesBlock.this.setDefaultRuntime(null);
                }
            }
        });
        this.runtimesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!AbstractRuntimesBlock.this.runtimesList.getSelection().isEmpty()) {
                    AbstractRuntimesBlock.this.editRuntime();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && AbstractRuntimesBlock.this.fRemoveButton.isEnabled()) {
                    AbstractRuntimesBlock.this.removeRuntimes();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)buttons, (String)"Add...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                AbstractRuntimesBlock.this.addRuntime();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)buttons, (String)"Edit...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                AbstractRuntimesBlock.this.editRuntime();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)buttons, (String)"Remove", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                AbstractRuntimesBlock.this.removeRuntimes();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.runtimesList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setRuntimes(IRuntime[] rts) {
        this.runtimes.clear();
        int i = 0;
        while (i < rts.length) {
            this.runtimes.add(rts[i]);
            ++i;
        }
        if (!this.runtimesList.getTable().isDisposed()) {
            this.runtimesList.setInput(this.runtimes);
        }
        IRuntime[] iRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.isDefault()) {
                this.setDefaultRuntime(runtime);
                break;
            }
            ++n2;
        }
        if (!this.runtimesList.getTable().isDisposed()) {
            this.runtimesList.refresh();
        }
    }

    public IRuntime[] getRuntimes() {
        IRuntime selected = this.getDefaultRuntime();
        for (IRuntime runtime : this.runtimes) {
            runtime.setDefault(runtime.equals(selected));
        }
        return this.runtimes.toArray(new IRuntime[this.runtimes.size()]);
    }

    private void addRuntime() {
        IRuntime result;
        AbstractRuntimeDialog dialog = this.createEditingDialog(this.getShell(), this.runtimes);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            this.runtimeManager.recognizeJars(result);
            this.runtimes.add(result);
            this.runtimesList.refresh();
            this.runtimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void editRuntime() {
        IRuntime result;
        IStructuredSelection selection = (IStructuredSelection)this.runtimesList.getSelection();
        IRuntime runtime = (IRuntime)selection.getFirstElement();
        if (runtime == null) {
            return;
        }
        AbstractRuntimeDialog dialog = this.createEditingDialog(this.getShell(), this.runtimes);
        dialog.setRuntime(runtime);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            this.runtimeManager.recognizeJars(result);
            int index = this.runtimes.indexOf(runtime);
            this.runtimes.remove(index);
            this.runtimes.add(index, result);
            this.runtimesList.refresh();
            this.runtimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void removeRuntimes() {
        IStructuredSelection selection = (IStructuredSelection)this.runtimesList.getSelection();
        IRuntime[] runtimes = new IRuntime[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            runtimes[i] = (IRuntime)iter.next();
            ++i;
        }
        this.removeRuntimes(runtimes);
    }

    public void removeRuntimes(IRuntime[] rts) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < rts.length) {
            this.runtimes.remove(rts[i]);
            ++i;
        }
        this.runtimesList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            rts = this.getRuntimes();
            if (curr.size() == 0 && rts.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)rts[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setDefaultRuntime(IRuntime runtime) {
        if (runtime == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)runtime));
        }
    }

    public IRuntime getDefaultRuntime() {
        Object[] objects = this.runtimesList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IRuntime)objects[0];
    }

    protected abstract IRuntimeManager getRuntimeManager();

    protected abstract AbstractRuntimeDialog createEditingDialog(Shell var1, List<IRuntime> var2);

    class RuntimesContentProvider
    implements IStructuredContentProvider {
        RuntimesContentProvider() {
        }

        public Object[] getElements(Object input) {
            return AbstractRuntimesBlock.this.runtimes.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class RuntimesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RuntimesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IRuntime) {
                IRuntime runtime = (IRuntime)element;
                switch (columnIndex) {
                    case 0: {
                        return runtime.getName();
                    }
                    case 1: {
                        return runtime.getPath();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

