/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.kie.eclipse.runtime.DefaultRuntimeRecognizer;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.runtime.IRuntimeManagerListener;
import org.kie.eclipse.runtime.IRuntimeRecognizer;
import org.osgi.framework.Bundle;

public abstract class AbstractRuntimeManager
implements IRuntimeManager {
    private static final String KIE_RUNTIME_RECOGNIZER = "org.kie.eclipse.runtimeRecognizer";
    private ArrayList<IRuntimeManagerListener> listeners = new ArrayList();

    @Override
    public void addListener(IRuntimeManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IRuntimeManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void addRuntime(IRuntime rt) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.add(rt);
        this.setRuntimesInternal(list.toArray(new IRuntime[list.size()]));
        this.fireRuntimeAdded(rt);
    }

    public void removeRuntime(IRuntime rt) {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        list.addAll(Arrays.asList(this.getConfiguredRuntimes()));
        list.remove(rt);
        this.setRuntimesInternal(list.toArray(new IRuntime[list.size()]));
        this.fireRuntimeRemoved(rt);
    }

    private void fireRuntimeAdded(IRuntime rt) {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeAdded(rt);
        }
    }

    private void fireRuntimeRemoved(IRuntime rt) {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimeRemoved(rt);
        }
    }

    private void fireRuntimesChanged() {
        Iterator<IRuntimeManagerListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().runtimesChanged(this.getConfiguredRuntimes());
        }
    }

    @Override
    public String getBundleRuntimeVersion() {
        String version = Platform.getBundle((String)this.getBundleSymbolicName()).getVersion().toString();
        String[] a = version.split("\\.");
        if (a.length > 3) {
            return String.valueOf(a[0]) + "." + a[1] + "." + a[2];
        }
        return version;
    }

    @Override
    public String getBundleRuntimeName() {
        return "Runtime for version " + this.getBundleRuntimeVersion();
    }

    @Override
    public IRuntime createBundleRuntime(String location) {
        ArrayList<String> jars = new ArrayList<String>();
        String s = this.getBundleLocation();
        File file = new Path(s).toFile();
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && files[i].getName().equals("lib")) {
                File[] jarFiles = files[i].listFiles();
                int j = 0;
                while (j < jarFiles.length) {
                    if (jarFiles[j].getPath().endsWith(".jar")) {
                        jars.add(jarFiles[j].getAbsolutePath());
                    }
                    ++j;
                }
            }
            ++i;
        }
        try {
            jars.add(FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.eclipse.jdt.core")).getAbsolutePath());
        }
        catch (IOException ex) {
            this.logException(ex);
        }
        String separator = "";
        if (!location.endsWith(File.separator)) {
            separator = File.separator;
        }
        ArrayList<String> jarsCreated = new ArrayList<String>();
        for (String jar : jars) {
            try {
                File jarFile = new File(jar);
                FileChannel inChannel = new FileInputStream(jarFile).getChannel();
                String createdJar = String.valueOf(location) + separator + jarFile.getName();
                FileChannel outChannel = new FileOutputStream(new File(createdJar)).getChannel();
                try {
                    inChannel.transferTo(0L, inChannel.size(), outChannel);
                    jarsCreated.add(createdJar);
                }
                finally {
                    if (inChannel != null) {
                        inChannel.close();
                    }
                    if (outChannel != null) {
                        outChannel.close();
                    }
                }
            }
            catch (Throwable t) {
                this.logException(t);
            }
        }
        IRuntime runtime = this.createNewRuntime();
        runtime.setName(this.getBundleRuntimeName());
        runtime.setVersion(this.getBundleRuntimeVersion());
        runtime.setPath(location);
        runtime.setJars(jarsCreated.toArray(new String[jarsCreated.size()]));
        return runtime;
    }

    private String getBundleLocation() {
        try {
            return FileLocator.toFileURL((URL)Platform.getBundle((String)this.getBundleSymbolicName()).getEntry("/")).getFile().toString();
        }
        catch (IOException e) {
            this.logException(e);
            return null;
        }
    }

    @Override
    public IRuntime getEffectiveRuntime(IRuntime selectedRuntime, boolean useDefault) {
        IFolder lib;
        boolean rebuildBundleRuntimeProject = false;
        String bundleRuntimeLocation = String.valueOf(this.getBundleRuntimeLocation()) + "_" + this.getBundleRuntimeVersion();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (selectedRuntime.getPath() != null) {
            IPath rootPath;
            Path runtimeRootPath = new Path(selectedRuntime.getPath());
            if ("lib".equals(runtimeRootPath.lastSegment())) {
                runtimeRootPath = runtimeRootPath.removeLastSegments(1);
            }
            if (bundleRuntimeLocation.equals(runtimeRootPath.lastSegment())) {
                runtimeRootPath = runtimeRootPath.removeLastSegments(1);
            }
            if ((rootPath = workspace.getRoot().getLocation()).equals((Object)runtimeRootPath)) {
                IProject project = workspace.getRoot().getProject(bundleRuntimeLocation);
                if (!project.isOpen()) {
                    try {
                        project.open(128, null);
                    }
                    catch (CoreException ex) {
                        this.logException(ex);
                    }
                }
                if (!project.exists()) {
                    rebuildBundleRuntimeProject = true;
                } else {
                    int jarCount = 0;
                    lib = project.getFolder("lib");
                    if (!lib.exists()) {
                        try {
                            project.delete(true, null);
                            rebuildBundleRuntimeProject = true;
                        }
                        catch (CoreException ex) {
                            this.logException(ex);
                        }
                    } else {
                        try {
                            IResource[] iResourceArray = lib.members();
                            int n = iResourceArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource f = iResourceArray[n2];
                                if ("jar".equals(f.getFileExtension())) {
                                    ++jarCount;
                                }
                                ++n2;
                            }
                        }
                        catch (CoreException ex) {
                            this.logException(ex);
                        }
                    }
                    if (jarCount == 0) {
                        rebuildBundleRuntimeProject = true;
                    }
                }
            }
        }
        ArrayList<IRuntime> runtimes = new ArrayList<IRuntime>();
        lib = this.getConfiguredRuntimes();
        int jarCount = ((IRuntime[])lib).length;
        int project = 0;
        while (project < jarCount) {
            IRuntime rt = lib[project];
            runtimes.add(rt);
            ++project;
        }
        if (selectedRuntime.getPath() == null || rebuildBundleRuntimeProject || runtimes.size() == 0) {
            for (IRuntime rt : runtimes) {
                if (!rt.getName().equals(selectedRuntime.getName())) continue;
                runtimes.remove(rt);
                break;
            }
            IProject project2 = workspace.getRoot().getProject(bundleRuntimeLocation);
            IFolder lib2 = project2.getFolder("lib");
            if (!project2.exists() || !lib2.exists()) {
                IProjectDescription description = workspace.newProjectDescription(project2.getName());
                description.setLocation(null);
                try {
                    project2.create(description, null);
                    project2.open(128, null);
                    lib2.create(true, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            String location = lib2.getLocation().removeTrailingSeparator().toString();
            selectedRuntime = this.createBundleRuntime(location);
            if (runtimes.size() == 0) {
                useDefault = true;
            }
            selectedRuntime.setDefault(useDefault);
            runtimes.add(selectedRuntime);
            this.setRuntimes(runtimes.toArray(new IRuntime[runtimes.size()]));
        }
        if (useDefault) {
            return this.getDefaultRuntime();
        }
        return selectedRuntime;
    }

    protected String createStringFromRuntimes(IRuntime[] runtimes) {
        String result = "";
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            result = String.valueOf(result) + runtime.getName() + "#" + runtime.getPath() + "#" + runtime.isDefault() + "# ";
            result = String.valueOf(result) + runtime.getProduct() + "#";
            result = String.valueOf(result) + runtime.getVersion() + "#";
            if (runtime.getJars() != null) {
                String[] stringArray = runtime.getJars();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jar = stringArray[n4];
                    result = String.valueOf(result) + jar + ";";
                    ++n4;
                }
            }
            result = String.valueOf(result) + "###";
            ++n2;
        }
        return result;
    }

    protected IRuntime[] createRuntimesFromString(String s) {
        ArrayList<IRuntime> result = new ArrayList<IRuntime>();
        if (s != null && !"".equals(s)) {
            String[] runtimeStrings;
            String[] stringArray = runtimeStrings = s.split("###");
            int n = runtimeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String runtimeString = stringArray[n2];
                String[] properties = runtimeString.split("#");
                IRuntime runtime = this.createNewRuntime();
                runtime.setName(properties[0]);
                String location = properties[1];
                File file = new File(location);
                if (file.exists()) {
                    runtime.setPath(location);
                    runtime.setDefault("true".equals(properties[2]));
                    if (properties.length > 3) {
                        int index = 3;
                        if (properties.length > 5) {
                            runtime.setProduct(properties[index++]);
                            runtime.setVersion(properties[index++]);
                        }
                        ArrayList<String> list = new ArrayList<String>();
                        String[] jars = properties[index].split(";");
                        while (index < jars.length) {
                            String jar = jars[index++];
                            if ((jar = jar.trim()).length() <= 0) continue;
                            list.add(jar);
                        }
                        runtime.setJars(list.toArray(new String[list.size()]));
                    }
                    result.add(runtime);
                }
                ++n2;
            }
        }
        return result.toArray(new IRuntime[result.size()]);
    }

    @Override
    public IRuntime[] getConfiguredRuntimes() {
        String runtimesString = this.getPreferenceStore().getString(this.getRuntimePreferenceKey());
        if (runtimesString != null) {
            return this.createRuntimesFromString(runtimesString);
        }
        return new IRuntime[0];
    }

    @Override
    public void setRuntimes(IRuntime[] runtimes) {
        this.setRuntimesInternal(runtimes);
        this.fireRuntimesChanged();
    }

    private void setRuntimesInternal(IRuntime[] runtimes) {
        this.getPreferenceStore().setValue(this.getRuntimePreferenceKey(), this.createStringFromRuntimes(runtimes));
    }

    public IRuntime getRuntime(String name) {
        IRuntime[] runtimes;
        IRuntime[] iRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.getName().equals(name)) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IRuntime getDefaultRuntime() {
        IRuntime[] runtimes;
        IRuntime[] iRuntimeArray = runtimes = this.getConfiguredRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            if (runtime.isDefault()) {
                return runtime;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setRuntime(IRuntime runtime, IProject project, IProgressMonitor monitor) throws CoreException {
        if (runtime != null) {
            IFile file = project.getFile(".settings/" + this.getSettingsFilename());
            String runtimeString = "<runtime>" + runtime.getName() + "</runtime>";
            if (!file.exists()) {
                IFolder folder = project.getProject().getFolder(".settings");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                file.create((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, null);
            } else {
                file.setContents((InputStream)new ByteArrayInputStream(runtimeString.getBytes()), true, false, null);
            }
        }
    }

    @Override
    public IRuntime getRuntime(IProject project) {
        try {
            BufferedReader reader;
            String location;
            IFile file = project.getFile(".settings/" + this.getSettingsFilename());
            if (file.exists() && (location = (reader = new BufferedReader(new InputStreamReader(file.getContents()))).readLine()).startsWith("<runtime>") && location.endsWith("</runtime>")) {
                String runtimeName = location.substring(9, location.length() - 10);
                return this.getRuntime(runtimeName);
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        return this.getDefaultRuntime();
    }

    public String[] getRuntimeJars(IProject project) {
        IRuntime runtime = this.getRuntime(project);
        if (runtime == null) {
            return null;
        }
        if (runtime.getJars() == null || runtime.getJars().length == 0) {
            this.recognizeJars(runtime);
        }
        return runtime.getJars();
    }

    @Override
    public void recognizeJars(IRuntime runtime) {
        String path = runtime.getPath();
        if (path != null) {
            try {
                IConfigurationElement[] config;
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(KIE_RUNTIME_RECOGNIZER);
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] jars;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IRuntimeRecognizer && (jars = ((IRuntimeRecognizer)o).recognizeJars(path)) != null && jars.length > 0) {
                        runtime.setJars(jars);
                        return;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            runtime.setJars(new DefaultRuntimeRecognizer().recognizeJars(path));
        }
    }

    public abstract String getBundleRuntimeLocation();

    public abstract String getRuntimePreferenceKey();

    @Override
    public abstract boolean isMavenized(IRuntime var1);

    @Override
    public abstract String getSettingsFilename();

    public abstract String getBundleSymbolicName();

    @Override
    public abstract IRuntime createNewRuntime();

    public abstract void logException(Throwable var1);

    public abstract IPreferenceStore getPreferenceStore();
}

