/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.jgit.lib.Repository;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.KieResourceHandler;

public class KieProjectHandler
extends KieResourceHandler
implements IKieProjectHandler {
    IProject project;
    File directory;

    public KieProjectHandler(IKieRepositoryHandler repository, String name) {
        super(repository, name);
    }

    @Override
    public Object getResource() {
        return this.project;
    }

    @Override
    public Object load() {
        Repository repository;
        if (this.project == null && (repository = (Repository)this.parent.load()) != null) {
            RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository projectRepo;
                IProject project = iProjectArray[n2];
                if (project.getName().equals(this.name) && repository == (projectRepo = repositoryCache.getRepository((IResource)project))) {
                    this.project = project;
                    this.directory = new File(project.getLocation().toString());
                    break;
                }
                ++n2;
            }
        }
        return this.project;
    }

    @Override
    public boolean isLoaded() {
        return this.project != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.project = null;
        this.directory = null;
    }

    @Override
    public List<? extends IKieResourceHandler> getChildren() throws Exception {
        return null;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }
}

