/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.RepositoryListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.KieResourceHandler;
import org.kie.eclipse.utils.PreferencesUtils;

public class KieRepositoryHandler
extends KieResourceHandler
implements IKieRepositoryHandler,
ConfigChangedListener,
IKieConstants {
    static RepositoryCache repositoryCache = Activator.getDefault().getRepositoryCache();
    Repository repository;

    public KieRepositoryHandler(IKieOrganizationHandler organization, String name) {
        super(organization, name);
    }

    public KieRepositoryHandler(IKieServerHandler server, String name) {
        super(server, name);
    }

    @Override
    public Object getResource() {
        return this.repository;
    }

    @Override
    public List<? extends IKieResourceHandler> getChildren() throws Exception {
        if (this.children == null || this.children.isEmpty()) {
            this.children = this.getDelegate().getProjects(this);
        }
        return this.children;
    }

    @Override
    public List<IKieProjectHandler> getProjects() throws Exception {
        return this.getChildren();
    }

    @Override
    public Object load() {
        if (this.repository == null) {
            final File repoRoot = new File(PreferencesUtils.getRepoRoot(this));
            final HashSet gitDirs = new HashSet();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Searching for Repositories", -1);
                    try {
                        KieRepositoryHandler.this.findGitDirsRecursive(repoRoot, gitDirs, monitor, false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService ps = PlatformUI.getWorkbench().getProgressService();
            try {
                ps.busyCursorWhile(runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            block6: for (File dir : gitDirs) {
                if (!this.getName().equals(dir.getParentFile().getName())) continue;
                try {
                    Repository repository = repositoryCache.lookupRepository(dir);
                    StoredConfig storedConfig = repository.getConfig();
                    Set remotes = storedConfig.getSubsections("remote");
                    for (String remoteName : remotes) {
                        String url = storedConfig.getString("remote", remoteName, "url");
                        System.out.println(repository.getDirectory());
                        System.out.println(url);
                        try {
                            URI u = new URI(url);
                            int port = u.getPort();
                            String host = u.getHost();
                            String scheme = u.getScheme();
                            String[] path = u.getPath().split("/");
                            String repoName = path[path.length - 1];
                            if (!this.name.equals(repoName) || !host.equals(this.getServer().getHost()) || port != this.getDelegate().getGitPort() || !"ssh".equals(scheme)) continue;
                            this.repository = repository;
                            continue block6;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.repository != null) {
                this.repository.getListenerList().addListener(ConfigChangedListener.class, (RepositoryListener)this);
            }
        }
        return this.repository;
    }

    private void findGitDirsRecursive(File repoRoot, Set<File> gitDirs, IProgressMonitor monitor, boolean lookForNestedRepositories) {
        if (!repoRoot.exists() || !repoRoot.isDirectory()) {
            return;
        }
        File[] children = repoRoot.listFiles();
        if (children == null) {
            return;
        }
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (child.isDirectory()) {
                if (RepositoryCache.FileKey.isGitRepository((File)child, (FS)FS.DETECTED)) {
                    gitDirs.add(child);
                } else if (RepositoryCache.FileKey.isGitRepository((File)new File(child, ".git"), (FS)FS.DETECTED)) {
                    gitDirs.add(new File(child, ".git"));
                } else if (lookForNestedRepositories) {
                    monitor.subTask(child.getPath());
                    this.findGitDirsRecursive(child, gitDirs, monitor, lookForNestedRepositories);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.repository != null;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void onConfigChanged(ConfigChangedEvent event) {
        System.out.println("onConfigChanged: repository=" + this.repository.getDirectory().getName());
    }
}

