/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Path;
import org.kie.eclipse.runtime.IRuntimeRecognizer;

public class DefaultRuntimeRecognizer
implements IRuntimeRecognizer {
    String version = "";
    String product = "";

    @Override
    public String[] recognizeJars(String path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path != null) {
            File file = new Path(path).toFile();
            this.addJarNames(file, list);
        }
        return list.toArray(new String[list.size()]);
    }

    private void addJarNames(File file, List<String> list) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            block23: {
                if (files[i].isDirectory() && "lib".equals(files[i].getName())) {
                    this.addJarNames(files[i], list);
                } else if (files[i].getPath().endsWith(".jar")) {
                    list.add(files[i].getAbsolutePath());
                    File jarFile = files[i];
                    if (jarFile.getName().startsWith("drools-core")) {
                        JarFile jar = null;
                        try {
                            try {
                                jar = new JarFile(jarFile);
                                for (Map.Entry<Object, Object> a : jar.getManifest().getMainAttributes().entrySet()) {
                                    if (!"Bundle-Version".equals(a.getKey().toString())) continue;
                                    String[] v = ((String)a.getValue()).split("\\.");
                                    if (v.length > 0) {
                                        this.version = v[0];
                                    }
                                    if (v.length > 1) {
                                        this.version = String.valueOf(this.version) + "." + v[1];
                                    }
                                    if (v.length > 2) {
                                        this.version = String.valueOf(this.version) + "." + v[2];
                                    }
                                    this.product = "drools";
                                }
                            }
                            catch (Exception exception) {
                                try {
                                    if (jar != null) {
                                        jar.close();
                                    }
                                    break block23;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (jar != null) {
                                    jar.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            if (jar != null) {
                                jar.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getProduct() {
        return this.product;
    }
}

