/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.kie.eclipse.Activator;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.utils.FileUtils;
import org.kie.eclipse.wizard.project.IKieOnlineExampleProjectWizardPage;
import org.kie.eclipse.wizard.project.IUTreeViewer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractKieOnlineExampleProjectWizardPage
extends WizardPage
implements IKieOnlineExampleProjectWizardPage {
    private static final String DROOLS_SAMPLE_PROJECTS_REPOSITORY = "org.kie.eclipse.sampleProjectsRepository";
    private final Collection<IInstallableUnit> EMPTY_IU_LIST = new ArrayList<IInstallableUnit>();
    private Composite onlineExampleProjectGroup;
    private Composite browserGroup;
    private IQueryResult<IInstallableUnit> queryResult;
    private IUTreeViewer onlineExamplesTree;
    private Collection<IInstallableUnit> installableUnits;
    private Browser browser;
    private ServiceReference<?> providerRef;
    private String repositoryUrl;

    @Override
    public abstract String getProductId();

    public AbstractKieOnlineExampleProjectWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("Select Online Example Repository:");
        final Combo repositoryCombo = new Combo(composite, 12);
        GridData gd = new GridData(3);
        gd.horizontalIndent = 10;
        repositoryCombo.setLayoutData((Object)gd);
        repositoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = repositoryCombo.getSelectionIndex();
                if (index >= 0) {
                    AbstractKieOnlineExampleProjectWizardPage.this.repositoryUrl = (String)repositoryCombo.getData(Integer.toString(index));
                    AbstractKieOnlineExampleProjectWizardPage.this.handleOnlineExampleProjectSelected();
                }
            }
        });
        this.fillRepositoryCombo(repositoryCombo);
        this.onlineExampleProjectGroup = new Composite(composite, 0);
        this.onlineExampleProjectGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.onlineExampleProjectGroup.setLayoutData((Object)gd);
        this.showGroup(this.onlineExampleProjectGroup, false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void showGroup(Composite group, boolean show) {
        if (group != null && !group.isDisposed()) {
            GridData gd = (GridData)group.getLayoutData();
            gd.exclude = !show;
            group.setVisible(show);
            if (show) {
                Point oldSize = this.getShell().getSize();
                Point newSize = this.getShell().computeSize(-1, -1, true);
                if (oldSize.x < newSize.x || oldSize.y < newSize.y) {
                    newSize.x = Math.max(oldSize.x, newSize.x);
                    newSize.y = Math.max(oldSize.y, newSize.y);
                    this.getShell().setSize(newSize);
                }
            }
            group.getParent().layout();
        }
    }

    private void fillRepositoryCombo(Combo repositoryCombo) {
        repositoryCombo.removeAll();
        repositoryCombo.add("<None Selected>");
        try {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(DROOLS_SAMPLE_PROJECTS_REPOSITORY);
            int index = 1;
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                e.getAttribute("id");
                String name = e.getAttribute("name");
                String product = e.getAttribute("product");
                String url = e.getAttribute("url");
                String gitUrl = e.getAttribute("gitUrl");
                if (product == null || product.equals(this.getProductId())) {
                    if (gitUrl != null) {
                        try {
                            Collection refs = Git.lsRemoteRepository().setHeads(true).setTags(true).setRemote(gitUrl).call();
                            if (refs.size() > 0) {
                                for (Ref ref : refs) {
                                    String[] a = ref.getName().split("/");
                                    if (a.length != 3) continue;
                                    String tagUrl = null;
                                    if ("heads".equals(a[1]) && url.contains("${BRANCH}")) {
                                        tagUrl = url.replace("${BRANCH}", a[2]);
                                    } else if ("tags".equals(a[1]) && url.contains("${TAG}")) {
                                        tagUrl = url.replace("${TAG}", a[2]);
                                    }
                                    if (tagUrl == null) continue;
                                    repositoryCombo.add(String.valueOf(name) + " (" + a[2] + ")");
                                    repositoryCombo.setData(Integer.toString(index), (Object)tagUrl);
                                    ++index;
                                }
                            } else {
                                gitUrl = null;
                            }
                        }
                        catch (InvalidRemoteException e2) {
                            gitUrl = null;
                            e2.printStackTrace();
                        }
                        catch (TransportException e2) {
                            gitUrl = null;
                            e2.printStackTrace();
                        }
                        catch (GitAPIException e2) {
                            gitUrl = null;
                            e2.printStackTrace();
                        }
                    }
                    if (gitUrl == null) {
                        repositoryCombo.add(name);
                        repositoryCombo.setData(Integer.toString(index), (Object)url);
                        ++index;
                    }
                }
                ++n2;
            }
            repositoryCombo.select(0);
            this.repositoryUrl = null;
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)ex.getMessage());
        }
    }

    private String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    private String createOnlineExampleProjectControls() {
        if (this.repositoryUrl == null) {
            this.queryResult = null;
            return "No Repository selected";
        }
        final String[] status = new String[1];
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    try {
                        IProvisioningAgent agent = AbstractKieOnlineExampleProjectWizardPage.this.createProvisiongAgent();
                        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                        IMetadataRepository repository = manager.loadRepository(new URI(AbstractKieOnlineExampleProjectWizardPage.this.getRepositoryUrl()), pm);
                        AbstractKieOnlineExampleProjectWizardPage.this.queryResult = repository.query(QueryUtil.createIUAnyQuery(), pm);
                    }
                    catch (Exception ex) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AbstractKieOnlineExampleProjectWizardPage.this.disposeOnlineExampleProjectControls();
                            }
                        });
                        status[0] = ex.getMessage();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            status[0] = e.getMessage();
        }
        if (status[0] != null) {
            return status[0];
        }
        if (this.onlineExamplesTree == null) {
            this.onlineExamplesTree = new IUTreeViewer(this.onlineExampleProjectGroup, 2048);
            this.onlineExamplesTree.initialize();
            this.browserGroup = new Composite(this.onlineExampleProjectGroup, 2048);
            this.browserGroup.setLayout((Layout)new GridLayout());
            this.browserGroup.setLayoutData((Object)new GridData(1808));
            this.browser = new Browser(this.browserGroup, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.onlineExamplesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IInstallableUnit iu = (IInstallableUnit)e.data;
                    boolean browserLoaded = true;
                    try {
                        IMatchExpression f = iu.getFilter();
                        if (f != null) {
                            Object[] objectArray = f.getParameters();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object p = objectArray[n2];
                                System.out.println(p);
                                ++n2;
                            }
                        }
                        System.out.println("IU Properties:");
                        for (Map.Entry pe : iu.getProperties().entrySet()) {
                            System.out.println("    " + (String)pe.getKey() + "=" + (String)pe.getValue());
                        }
                        for (ITouchpointData tp : iu.getTouchpointData()) {
                            System.out.println("IU Touchpoints:");
                            for (Map.Entry entry : tp.getInstructions().entrySet()) {
                                System.out.println("    " + (String)entry.getKey() + "=" + entry.getValue());
                            }
                        }
                        String text = iu.getProperty("org.eclipse.equinox.p2.description", "df_LT");
                        String url = iu.getProperty("org.eclipse.equinox.p2.description.url");
                        if (text != null && !text.isEmpty()) {
                            AbstractKieOnlineExampleProjectWizardPage.this.browser.setText(text);
                        } else if (AbstractKieOnlineExampleProjectWizardPage.this.testURL(url)) {
                            AbstractKieOnlineExampleProjectWizardPage.this.browser.setUrl(url);
                        } else {
                            AbstractKieOnlineExampleProjectWizardPage.this.browser.setText("<html><body>No description is available for <b>" + iu.getProperty("org.eclipse.equinox.p2.name") + "</b></body></html>");
                        }
                    }
                    catch (Exception exception) {
                        browserLoaded = false;
                        MessageDialog.openError((Shell)AbstractKieOnlineExampleProjectWizardPage.this.getShell(), (String)"Error", (String)"Cannot initialize Browser");
                    }
                    AbstractKieOnlineExampleProjectWizardPage.this.showGroup(AbstractKieOnlineExampleProjectWizardPage.this.browserGroup, browserLoaded);
                    AbstractKieOnlineExampleProjectWizardPage.this.onlineExamplesTree.getTree().pack();
                    AbstractKieOnlineExampleProjectWizardPage.this.onlineExampleProjectGroup.layout();
                    AbstractKieOnlineExampleProjectWizardPage.this.installableUnits = AbstractKieOnlineExampleProjectWizardPage.this.onlineExamplesTree.getSelectedIUs();
                    AbstractKieOnlineExampleProjectWizardPage.this.setPageComplete(AbstractKieOnlineExampleProjectWizardPage.this.isPageComplete());
                }
            });
        }
        this.onlineExamplesTree.setInput(this.queryResult);
        this.showGroup(this.browserGroup, false);
        this.browser.setText("");
        if (this.onlineExamplesTree.getTree().getItemCount() == 0) {
            this.disposeOnlineExampleProjectControls();
            return "No examples were found in the repository.";
        }
        return null;
    }

    private void handleOnlineExampleProjectSelected() {
        String error = this.createOnlineExampleProjectControls();
        if (error == null) {
            this.showGroup(this.browserGroup, false);
            this.showGroup(this.onlineExampleProjectGroup, true);
            this.installableUnits = this.onlineExamplesTree.getSelectedIUs();
        } else {
            this.showGroup(this.browserGroup, false);
            this.showGroup(this.onlineExampleProjectGroup, false);
            if (this.repositoryUrl != null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)NLS.bind((String)"Unable to load online examples from\n{0}\nCause:\n{1}", (Object)this.getRepositoryUrl(), (Object)error));
            }
            this.installableUnits = null;
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void disposeOnlineExampleProjectControls() {
        if (this.onlineExamplesTree != null) {
            if (!this.onlineExamplesTree.getTree().isDisposed()) {
                this.onlineExamplesTree.dispose();
            }
            this.onlineExamplesTree = null;
        }
        if (this.browser != null) {
            if (!this.browser.isDisposed()) {
                this.browser.dispose();
            }
            this.browser = null;
        }
    }

    @Override
    public String downloadOnlineExampleProject(IProject project, IProgressMonitor monitor) {
        String projectName = project.getName();
        try {
            for (IInstallableUnit iu : this.getInstallableUnits()) {
                if (!projectName.equals(iu.getId())) continue;
                for (IArtifactKey k : iu.getArtifacts()) {
                    String filename = String.valueOf(k.getId()) + "_" + k.getVersion() + ".jar";
                    URL url = new URL(String.valueOf(this.getRepositoryUrl()) + "/plugins/" + filename);
                    File jarFile = FileUtils.downloadFile(url, monitor);
                    FileUtils.extractJarFile(jarFile, project, monitor);
                    jarFile.delete();
                    project.refreshLocal(2, monitor);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    private boolean testURL(String urlString) {
        boolean result = true;
        HttpURLConnection httpConnection = null;
        try {
            try {
                URL url = new URL(urlString);
                httpConnection = (HttpURLConnection)url.openConnection();
                httpConnection.getContent();
                httpConnection.disconnect();
                httpConnection = null;
            }
            catch (UnknownHostException unknownHostException) {
                result = false;
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
            catch (IOException iOException) {
                result = false;
                if (httpConnection != null) {
                    httpConnection.disconnect();
                }
            }
        }
        finally {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
        }
        return result;
    }

    public Collection<IInstallableUnit> getInstallableUnits() {
        if (this.installableUnits == null) {
            return this.EMPTY_IU_LIST;
        }
        return this.installableUnits;
    }

    public void dispose() {
        if (this.providerRef != null) {
            Activator.getContext().ungetService(this.providerRef);
            this.providerRef = null;
        }
        super.dispose();
    }

    private IProvisioningAgent createProvisiongAgent() throws ProvisionException {
        IProvisioningAgent result = null;
        this.providerRef = Activator.getContext().getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
        if (this.providerRef == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)Activator.getContext().getService(this.providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        result = provider.createAgent(null);
        return result;
    }

    @Override
    public IRuntime getRuntime() {
        IRuntime effectiveRuntime = this.getRuntimeManager().getEffectiveRuntime(null, true);
        return effectiveRuntime;
    }

    @Override
    public Collection<IProjectDescription> getNewProjectDescriptions() {
        ArrayList<IProjectDescription> result = new ArrayList<IProjectDescription>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        for (IInstallableUnit iu : this.getInstallableUnits()) {
            String name = iu.getId();
            IProject project = this.getProjectHandle(name);
            IProjectDescription description = workspace.newProjectDescription(project.getName());
            result.add(description);
        }
        return result;
    }

    private IProject getProjectHandle(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public boolean isPageComplete() {
        return this.getInstallableUnits().size() > 0;
    }

    public IWizardPage getNextPage() {
        return null;
    }
}

