/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import com.eclipsesource.json.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.kie.eclipse.Activator;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.server.Base64Util;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public abstract class KieServiceDelegate
implements IKieServiceDelegate,
IKieConstants {
    protected IKieResourceHandler handler;
    protected IServer server;
    protected static List<String> kieApplicationNames = new ArrayList<String>();
    private String kieApplication;
    private int httpPort = -1;
    private static int STATUS_REQUEST_DELAY;
    private static int STATUS_REQUEST_TIMEOUT;

    static {
        kieApplicationNames.add("kie-wb");
        kieApplicationNames.add("kie-drools-wb");
        kieApplicationNames.add("kie-jbpm-wb");
        kieApplicationNames.add("business-central");
        kieApplicationNames.add("drools-console");
        kieApplicationNames.add("jbpm-console");
        kieApplicationNames.add("jboss-brms");
        STATUS_REQUEST_DELAY = 1000;
        STATUS_REQUEST_TIMEOUT = 60000;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public void setHandler(IKieResourceHandler handler) {
        this.handler = handler;
    }

    @Override
    public IKieResourceHandler getHandler() {
        return this.handler;
    }

    private void setHttpCredentials(HttpURLConnection conn) {
        String creds = String.valueOf(this.getUsername()) + ":" + this.getPassword();
        conn.setRequestProperty("Authorization", "Basic " + Base64Util.encode(creds));
    }

    protected String httpGet(String request) throws IOException {
        String host = this.getKieRESTUrl();
        URL url = new URL(String.valueOf(host) + "/" + request);
        Activator.println("[GET] " + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content", "application/json");
        this.setHttpCredentials(conn);
        String response = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
        Activator.println("[GET] response: " + response);
        return response;
    }

    protected String httpDelete(String request) throws IOException {
        String host = this.getKieRESTUrl();
        URL url = new URL(String.valueOf(host) + "/" + request);
        Activator.println("[DELETE] " + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("DELETE");
        conn.setRequestProperty("Content", "application/json");
        this.setHttpCredentials(conn);
        String response = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
        Activator.println("[DELETE] response: " + response);
        if (conn.getResponseCode() != 202) {
            throw new IOException("HTTP DELETE failed : HTTP error code : " + conn.getResponseCode());
        }
        JsonObject jo = JsonObject.readFrom(response);
        String status = jo.get("status").asString();
        if (status != null && !status.isEmpty() && !"APPROVED".equals(status)) {
            throw new IOException("HTTP DELETE failed : Request status code : " + status);
        }
        String jobId = jo.get("jobId").asString();
        if (jobId != null && !jobId.isEmpty()) {
            return jobId;
        }
        return response;
    }

    protected String httpPost(String request, JsonObject body) throws IOException, RuntimeException {
        String host = this.getKieRESTUrl();
        URL url = new URL(String.valueOf(host) + "/" + request);
        Activator.println("[POST] " + url.toString() + " body: " + body);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(body != null);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        this.setHttpCredentials(conn);
        if (body != null) {
            OutputStream os = conn.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(os, "UTF-8");
            body.writeTo(writer);
            ((Writer)writer).close();
            os.flush();
        }
        String response = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
        Activator.println("[POST] response: " + response);
        if (conn.getResponseCode() != 202) {
            throw new IOException("HTTP POST failed : HTTP error code : " + conn.getResponseCode());
        }
        JsonObject jo = JsonObject.readFrom(response);
        String status = jo.get("status").asString();
        if (status != null && !status.isEmpty() && !"APPROVED".equals(status)) {
            throw new IOException("HTTP POST failed : Request status code : " + status);
        }
        String jobId = jo.get("jobId").asString();
        if (jobId != null && !jobId.isEmpty()) {
            return jobId;
        }
        return response;
    }

    public String getJobStatus(final String jobId, final String title) throws IOException, InterruptedException {
        final AtomicReference ar = new AtomicReference();
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        try {
            ps.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InterruptedException {
                    long startTime;
                    pm.beginTask("Waiting for Job " + jobId + ":\n\n" + title, STATUS_REQUEST_TIMEOUT);
                    pm.subTask(title);
                    long stopTime = startTime = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(STATUS_REQUEST_DELAY);
                            String response = KieServiceDelegate.this.httpGet("jobs/" + jobId);
                            JsonObject jo = JsonObject.readFrom(response);
                            String status = jo.get("status").asString();
                            String result = jo.get("result").asString();
                            if ("null".equals(result) && !"SUCCESS".equals(status)) {
                                result = null;
                            }
                            if (status != null && result != null) {
                                ar.set(String.valueOf(status) + ":" + result);
                            }
                            stopTime = System.currentTimeMillis();
                            pm.worked(STATUS_REQUEST_DELAY);
                            Activator.println("status=" + status);
                            Activator.println("result=" + result);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!pm.isCanceled()) continue;
                        throw new InterruptedException("Operation canceled");
                    } while (ar.get() == null && stopTime - startTime < (long)STATUS_REQUEST_TIMEOUT);
                    pm.done();
                    Activator.println("\n----------------------------------\nJob " + jobId + "\n" + title + "\ncompleted in " + (double)(stopTime - startTime) / 1000.0 + " sec\n" + "Status: " + (String)ar.get() + "\n----------------------------------\n");
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        return (String)ar.get();
    }

    public void deleteJob(String jobId) {
        try {
            this.httpDelete("jobs/" + jobId);
        }
        catch (Exception exception) {}
    }

    @Override
    public String getUsername() {
        return this.handler.getPreference("ServerUsername", "");
    }

    @Override
    public String getPassword() {
        return this.handler.getPreference("ServerPassword", "");
    }

    @Override
    public int getGitPort() {
        return this.handler.getPreference("ServerGitPort", 8001);
    }

    @Override
    public String getKieApplication() {
        if (this.kieApplication == null) {
            String app = this.handler.getPreference("ServerKieApplicationName", null);
            if (app != null) {
                try {
                    this.kieApplication = app;
                    Activator.print("Trying " + this.getKieRESTUrl() + "...");
                    this.httpGet("organizationalunits");
                    Activator.println("success!");
                }
                catch (Exception exception) {
                    Activator.println("not found");
                    this.kieApplication = null;
                }
            }
            if (this.kieApplication == null) {
                for (String s : kieApplicationNames) {
                    try {
                        this.kieApplication = s;
                        Activator.print("Trying " + this.getKieRESTUrl() + "...");
                        this.httpGet("organizationalunits");
                        this.handler.putPreference("ServerKieApplicationName", s);
                        Activator.println("success!");
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Activator.println("not found");
                        this.kieApplication = null;
                    }
                    catch (IOException iOException) {
                        Activator.println("not authorized");
                        break;
                    }
                    catch (Exception e2) {
                        Activator.println(e2.getMessage());
                        this.kieApplication = null;
                    }
                }
            }
        }
        return this.kieApplication;
    }

    public void setKieApplication(String kieApplication) {
        this.kieApplication = kieApplication;
    }

    @Override
    public int getHttpPort() {
        if (this.httpPort == -1) {
            ServerPort[] ports;
            ServerPort[] serverPortArray = ports = this.getServer().getServerPorts(null);
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPort port = serverPortArray[n2];
                if ("HTTP".equals(port.getProtocol())) {
                    this.httpPort = port.getPort();
                    if (this.httpPort != 0) break;
                    this.httpPort = -1;
                    break;
                }
                ++n2;
            }
            if (this.httpPort == -1) {
                return this.handler.getPreference("ServerHttpPort", 8080);
            }
        }
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    protected String getKieRESTUrl() {
        String kieApp = this.getKieApplication();
        if (kieApp == null) {
            kieApp = this.handler.getPreference("ServerKieApplicationName", null);
            if (kieApp == null) {
                throw new IllegalArgumentException("Can't determine KIE Application Name");
            }
            throw new IllegalArgumentException("KIE Application '" + kieApp + "' is not deployed");
        }
        return "http://" + this.getServer().getHost() + ":" + this.getHttpPort() + "/" + kieApp + "/rest";
    }
}

