/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server.jbpm770;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieSpaceHandler;
import org.kie.eclipse.server.KieProjectHandler;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.server.KieServiceDelegate;
import org.kie.eclipse.server.KieSpaceHandler;
import org.kie.eclipse.server.jbpm770.JobFailedException;
import org.kie.eclipse.server.jbpm770.Requester;

public class Kie770Service
extends KieServiceDelegate {
    private final Requester requester = new Requester(this);

    @Override
    public List<IKieSpaceHandler> getSpaces(IKieServerHandler server) throws IOException {
        ArrayList<IKieSpaceHandler> ret = new ArrayList<IKieSpaceHandler>();
        for (JsonValue spaceJson : this.httpGetSpaces()) {
            ret.add(this.newKieSpaceHandler(server, spaceJson.asObject()));
        }
        return ret;
    }

    @Override
    public List<IKieRepositoryHandler> getRepositories(IKieServerHandler server) throws IOException {
        ArrayList<IKieRepositoryHandler> ret = new ArrayList<IKieRepositoryHandler>();
        for (JsonValue spaceJson : this.httpGetSpaces()) {
            IKieSpaceHandler space = this.newKieSpaceHandler(server, spaceJson.asObject());
            for (JsonValue projectJson : space.getProperties().get("projects").asArray()) {
                ret.add(this.newKieRepositoryHandler(space, projectJson.asObject()));
            }
        }
        return ret;
    }

    @Override
    public List<IKieRepositoryHandler> getRepositories(IKieSpaceHandler space) throws IOException {
        ArrayList<IKieRepositoryHandler> ret = new ArrayList<IKieRepositoryHandler>();
        for (JsonValue projectJson : this.httpGetRepositories(space)) {
            ret.add(this.newKieRepositoryHandler(space, projectJson.asObject()));
        }
        return ret;
    }

    @Override
    public List<IKieProjectHandler> getProjects(IKieRepositoryHandler repository) {
        KieProjectHandler project = new KieProjectHandler(repository, repository.getName());
        project.setProperties(repository.getProperties());
        return new ArrayList<IKieProjectHandler>(Collections.singletonList(project));
    }

    private IKieSpaceHandler newKieSpaceHandler(IKieServerHandler server, JsonObject spaceJson) {
        KieSpaceHandler space = new KieSpaceHandler(server, spaceJson.get("name").asString());
        space.setProperties(spaceJson);
        return space;
    }

    private IKieRepositoryHandler newKieRepositoryHandler(IKieSpaceHandler space, JsonObject projectJson) {
        KieRepositoryHandler repository = new KieRepositoryHandler(space, projectJson.get("name").asString());
        repository.setProperties(projectJson);
        return repository;
    }

    @Override
    protected JsonArray httpGetSpaces() throws IOException {
        return JsonArray.readFrom(this.httpGet("spaces/"));
    }

    @Override
    protected JsonArray httpGetRepositories(IKieSpaceHandler space) throws IOException {
        return JsonArray.readFrom(this.httpGet("spaces/" + space.getName() + "/projects"));
    }

    @Override
    public void createSpace(final IKieSpaceHandler space) throws IOException {
        this.runJob("Request to create space '" + space.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/", space.getProperties());
            }
        });
    }

    @Override
    public void deleteSpace(final IKieSpaceHandler space) throws IOException {
        this.runJob("Request to delete space '" + space.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpDelete("spaces/" + space.getName());
            }
        });
    }

    @Override
    public void updateSpace(String oldName, IKieSpaceHandler space) throws IOException {
    }

    @Override
    public void createRepository(final IKieRepositoryHandler repository) throws IOException {
        this.runJob("Request to create repository '" + repository.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/" + repository.getParent().getName() + "/projects/", repository.getProperties());
            }
        });
    }

    @Override
    public void addRepository(IKieRepositoryHandler repository, IKieSpaceHandler space) throws IOException {
    }

    @Override
    public void deleteRepository(final IKieRepositoryHandler repository, boolean removeOnly) throws IOException {
        final String spaceName = repository.getParent().getName();
        this.runJob("Request to delete repository '" + repository.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpDelete("spaces/" + spaceName + "/projects/" + repository.getName());
            }
        });
    }

    @Override
    public void createProject(IKieProjectHandler project) throws IOException {
    }

    @Override
    public void deleteProject(IKieProjectHandler project) throws IOException {
    }

    public void mavenCompile(final IKieProjectHandler project, final JsonObject params) throws IOException {
        final String spaceName = project.getParent().getParent().getName();
        this.runJob("Request to compile Project '" + project.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/" + spaceName + "/projects/" + project.getName() + "/maven/compile/", params);
            }
        });
    }

    public void mavenInstall(final IKieProjectHandler project, final JsonObject params) throws IOException {
        final String spaceName = project.getParent().getParent().getName();
        this.runJob("Request to install Project '" + project.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/" + spaceName + "/projects/" + project.getName() + "/maven/install/", params);
            }
        });
    }

    public void mavenTest(final IKieProjectHandler project, final JsonObject params) throws IOException {
        final String spaceName = project.getParent().getParent().getName();
        this.runJob("Request to test Project '" + project.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/" + spaceName + "/projects/" + project.getName() + "/maven/test/", params);
            }
        });
    }

    public void mavenDeploy(final IKieProjectHandler project, final JsonObject params) throws IOException {
        final String spaceName = project.getParent().getParent().getName();
        this.runJob("Request to deploy Project '" + project.getName() + "'", new Requester.Action(){

            @Override
            public String execute() throws IOException {
                return Kie770Service.this.httpPost("spaces/" + spaceName + "/projects/" + project.getName() + "/maven/deploy/", params);
            }
        });
    }

    private void runJob(String title, Requester.Action action) throws IOException {
        try {
            this.requester.run(title, action);
        }
        catch (JobFailedException e) {
            this.deleteJob(e.getJobId());
        }
    }

    @Override
    public void updateProject(String oldName, IKieProjectHandler project) throws IOException {
    }

    @Override
    public void updateRepository(String oldName, IKieRepositoryHandler repository) throws IOException {
    }
}

