/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.runtime;

import org.kie.eclipse.runtime.IRuntime;

public abstract class AbstractRuntime
implements IRuntime {
    protected Version version = new Version();
    protected String name;
    protected String path;
    protected boolean isDefault;
    protected String[] jars;

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = new Version(version);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String[] getJars() {
        return this.jars;
    }

    @Override
    public void setJars(String[] jars) {
        this.jars = jars;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public abstract String getProduct();

    @Override
    public void setProduct(String string) {
    }

    @Override
    public String getId() {
        return AbstractRuntime.createRuntimeId(this.getProduct(), this.getVersion().toString());
    }

    public static String createRuntimeId(String product, String version) {
        return String.valueOf(product) + "_" + version;
    }

    public static String getProductFromId(String runtimeId) {
        int i = runtimeId.lastIndexOf("_");
        if (i > 0) {
            return runtimeId.substring(0, i);
        }
        return null;
    }

    public static String getVersionFromId(String runtimeId) {
        int i = runtimeId.lastIndexOf("_");
        if (i > 0) {
            return runtimeId.substring(i + 1);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IRuntime) {
            IRuntime that = (IRuntime)obj;
            if (this.getProduct().equals(that.getProduct()) && this.getVersion().equals(that.getVersion())) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public int compareTo(IRuntime that) {
        int i = this.getProduct().compareTo(that.getProduct());
        if (i == 0) {
            i = this.getVersion() == null ? -1 : this.getVersion().toString().compareTo(that.getVersion().toString());
        }
        return i;
    }

    public static class Version
    implements Comparable<Version> {
        int major = -1;
        int minor = -1;
        int patch = -2;
        String build = null;

        public Version(String version) {
            this();
            if (Version.validate(version) == null) {
                String[] parts = version.split("\\.");
                this.major = Integer.parseInt(parts[0]);
                this.minor = Integer.parseInt(parts[1]);
                this.patch = parts[2].equalsIgnoreCase("X") ? -1 : Integer.parseInt(parts[2]);
                int i = 3;
                while (i < parts.length) {
                    this.build = this.build == null ? parts[i] : String.valueOf(this.build) + "." + parts[i];
                    ++i;
                }
                if (this.build != null && this.build.isEmpty()) {
                    this.build = null;
                }
            }
        }

        public Version() {
        }

        public boolean isValid() {
            return this.major >= 0 && this.minor >= 0 && this.patch >= -1;
        }

        public static String validate(String version) {
            int major = -1;
            int minor = -1;
            int patch = -2;
            if (version == null || version.isEmpty()) {
                return "Version may not be empty";
            }
            String[] parts = version.split("\\.");
            if (parts.length < 3) {
                return "Version must be in the form major#.minor#.patch#[.build-name]";
            }
            try {
                major = Integer.parseInt(parts[0]);
                minor = Integer.parseInt(parts[1]);
                patch = parts[2].equalsIgnoreCase("X") ? -1 : Integer.parseInt(parts[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (major < 0) {
                return "Version major number is invalid";
            }
            if (minor < 0) {
                return "Version minor number is invalid";
            }
            if (patch < -1) {
                return "Version patch number is invalid";
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof Version) {
                Version that = (Version)obj;
                if (this.major == that.major && this.minor == that.minor && (this.patch == -1 || that.patch == -1 || this.patch == that.patch)) {
                    if (this.build == null && that.build == null) {
                        return true;
                    }
                    if (this.build != null && this.build.equals(that.build)) {
                        return true;
                    }
                }
                return false;
            }
            return obj.toString().equals(this.toString());
        }

        public boolean compatible(Version that) {
            return this.major == that.major && this.minor == that.minor && (this.patch == -1 || that.patch == -1 || this.patch == that.patch);
        }

        @Override
        public int compareTo(Version that) {
            int i = this.major - that.major;
            if (i == 0 && (i = this.minor - that.minor) == 0) {
                if (this.patch == -1) {
                    return -1;
                }
                if (that.patch == -1) {
                    return 1;
                }
                i = this.patch - that.patch;
            }
            return i;
        }

        public String toString() {
            String version = (this.major < 0 ? "z" : Integer.valueOf(this.major)) + "." + (this.minor < 0 ? "y" : Integer.valueOf(this.minor)) + "." + (this.patch < 0 ? "x" : Integer.valueOf(this.patch));
            if (this.build != null && !this.build.isEmpty()) {
                version = String.valueOf(version) + "." + this.build;
            }
            return version;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public String getBuild() {
            return this.build;
        }
    }
}

