/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.utils;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class PreferencesUtils
implements IKieConstants {
    private static final String core_defaultRepositoryDir = "core_defaultRepositoryDir";
    private static final String deprecated_defaultRespositoryDir = "default_repository_dir";
    private static final String egitPluginId = "org.eclipse.egit.core";
    private static final String deprecatedEgitPreferences = "org.eclipse.egit.ui";

    public static String getRepoRoot(IKieRepositoryHandler repository) {
        String repoRoot;
        IKieServerHandler server = (IKieServerHandler)repository.getRoot();
        boolean useDefaultGitPath = server.getPreference("UseDefaultGitPath", false);
        String defaultRepoRoot = PreferencesUtils.getDefaultRepositoryDir();
        if (useDefaultGitPath) {
            repoRoot = defaultRepoRoot;
        } else {
            defaultRepoRoot = String.valueOf(defaultRepoRoot) + File.separator + server.getPreferenceName(null).replace("|".charAt(0), File.separator.charAt(0));
            repoRoot = server.getPreference("RepositoryPath", defaultRepoRoot);
        }
        return repoRoot;
    }

    public static String getRepoPath(IKieRepositoryHandler repository) {
        return String.valueOf(PreferencesUtils.getRepoRoot(repository)) + File.separator + repository.getName();
    }

    public static URIish getRepoURI(IKieRepositoryHandler repository) {
        IKieServiceDelegate delegate = repository.getDelegate();
        String host = delegate.getServer().getHost();
        int port = delegate.getGitPort();
        String username = delegate.getUsername();
        return PreferencesUtils.getRepoURI(host, port, username, repository.getName());
    }

    public static URIish getRepoURI(String host, int port, String username, String repoName) {
        URIish uri = null;
        try {
            uri = new URIish("ssh://" + (username == null || username.isEmpty() ? "" : String.valueOf(username) + "@") + host + ":" + port + "/" + repoName);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return uri;
    }

    public static String getDefaultRepositoryDir() {
        String result;
        String key = core_defaultRepositoryDir;
        String dir = PreferencesUtils.getDeprecatedRepoRootPreference();
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(egitPluginId);
        if (dir == null) {
            dir = p.get(key, PreferencesUtils.getDefaultDefaultRepositoryDir());
        }
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            result = manager.performStringSubstitution(dir);
        }
        catch (CoreException e) {
            result = "";
        }
        if (result == null || result.isEmpty()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toOSString();
        }
        return result;
    }

    private static String getDefaultDefaultRepositoryDir() {
        return new File(FS.DETECTED.userHome(), "git").getPath();
    }

    private static String getDeprecatedRepoRootPreference() {
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode(deprecatedEgitPreferences);
        String value = p.get(deprecated_defaultRespositoryDir, null);
        if (value != null && value.isEmpty()) {
            value = null;
        }
        return value;
    }
}

