/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic.calculatecount;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.statistic.AbstractProblemStatistic;
import org.drools.planner.benchmark.core.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;
import org.drools.planner.benchmark.core.statistic.SingleStatistic;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountSingleStatistic;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountSingleStatisticPoint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CalculateCountProblemStatistic
extends AbstractProblemStatistic {
    protected File graphStatisticFile = null;

    public CalculateCountProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.CALCULATE_COUNT_PER_SECOND);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new CalculateCountSingleStatistic();
    }

    public String getGraphFilePath() {
        return this.toFilePath(this.graphStatisticFile);
    }

    @Override
    protected void writeCsvStatistic() {
        AbstractProblemStatistic.ProblemStatisticCsv csv = new AbstractProblemStatistic.ProblemStatisticCsv();
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            if (singleBenchmark.isSuccess()) {
                CalculateCountSingleStatistic singleStatistic = (CalculateCountSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (CalculateCountSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    csv.addPoint(singleBenchmark, timeMillisSpend, point.getCalculateCountPerSecond());
                }
                continue;
            }
            csv.addPoint(singleBenchmark, 0L, "Failed");
        }
        this.csvStatisticFile = new File(this.problemBenchmark.getProblemReportDirectory(), this.problemBenchmark.getName() + "CalculateCountStatistic.csv");
        csv.writeCsvStatisticFile();
    }

    @Override
    protected void writeGraphStatistic() {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Calculate count per second");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            XYSeries series = new XYSeries((Comparable)((Object)singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix()));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            if (singleBenchmark.isSuccess()) {
                CalculateCountSingleStatistic singleStatistic = (CalculateCountSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (CalculateCountSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    long calculateCountPerSecond = point.getCalculateCountPerSecond();
                    series.add((double)timeMillisSpend, (double)calculateCountPerSecond);
                }
            }
            plot.setDataset(seriesIndex, (XYDataset)new XYSeriesCollection(series));
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " calculate count statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphStatisticFile = this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "CalculateCountStatistic");
    }
}

