/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic.calculatecount;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.core.statistic.AbstractSingleStatistic;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountSingleStatisticPoint;
import org.drools.planner.core.Solver;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolver;
import org.drools.planner.core.solver.scope.DefaultSolverScope;

public class CalculateCountSingleStatistic
extends AbstractSingleStatistic {
    private long timeMillisThresholdInterval;
    private long nextTimeMillisThreshold;
    private final CalculateCountSingleStatisticListener listener = new CalculateCountSingleStatisticListener();
    private long lastTimeMillisSpend = 0L;
    private long lastCalculateCount = 0L;
    private List<CalculateCountSingleStatisticPoint> pointList = new ArrayList<CalculateCountSingleStatisticPoint>();

    public CalculateCountSingleStatistic() {
        this(1000L);
    }

    public CalculateCountSingleStatistic(long timeMillisThresholdInterval) {
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.nextTimeMillisThreshold = timeMillisThresholdInterval;
    }

    public List<CalculateCountSingleStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    private class CalculateCountSingleStatisticListener
    extends SolverPhaseLifecycleListenerAdapter {
        private CalculateCountSingleStatisticListener() {
        }

        public void stepEnded(AbstractStepScope stepScope) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            if (timeMillisSpend >= CalculateCountSingleStatistic.this.nextTimeMillisThreshold) {
                DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
                long calculateCount = solverScope.getCalculateCount();
                long calculateCountInterval = calculateCount - CalculateCountSingleStatistic.this.lastCalculateCount;
                long timeMillisSpendInterval = timeMillisSpend - CalculateCountSingleStatistic.this.lastTimeMillisSpend;
                if (timeMillisSpendInterval == 0L) {
                    timeMillisSpendInterval = 1L;
                }
                long averageCalculateCountPerSecond = calculateCountInterval * 1000L / timeMillisSpendInterval;
                CalculateCountSingleStatistic.this.pointList.add(new CalculateCountSingleStatisticPoint(timeMillisSpend, averageCalculateCountPerSecond));
                CalculateCountSingleStatistic.this.lastCalculateCount = calculateCount;
                CalculateCountSingleStatistic.this.lastTimeMillisSpend = timeMillisSpend;
                CalculateCountSingleStatistic.this.nextTimeMillisThreshold += CalculateCountSingleStatistic.this.timeMillisThresholdInterval;
                if (CalculateCountSingleStatistic.this.nextTimeMillisThreshold < timeMillisSpend) {
                    CalculateCountSingleStatistic.this.nextTimeMillisThreshold = timeMillisSpend;
                }
            }
        }
    }
}

