/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic;

import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.benchmark.core.statistic.StatisticType;
import org.drools.planner.benchmark.core.statistic.bestscore.BestScoreProblemStatistic;
import org.drools.planner.benchmark.core.statistic.calculatecount.CalculateCountProblemStatistic;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseProblemStatistic;

public enum ProblemStatisticType implements StatisticType
{
    BEST_SOLUTION_CHANGED,
    CALCULATE_COUNT_PER_SECOND,
    MEMORY_USE;


    public ProblemStatistic create(ProblemBenchmark problemBenchmark) {
        switch (this) {
            case BEST_SOLUTION_CHANGED: {
                return new BestScoreProblemStatistic(problemBenchmark);
            }
            case CALCULATE_COUNT_PER_SECOND: {
                return new CalculateCountProblemStatistic(problemBenchmark);
            }
            case MEMORY_USE: {
                return new MemoryUseProblemStatistic(problemBenchmark);
            }
        }
        throw new IllegalStateException("The problemStatisticType (" + this + ") is not implemented.");
    }
}

