/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic.memoryuse;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.statistic.AbstractProblemStatistic;
import org.drools.planner.benchmark.core.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.core.statistic.ProblemStatisticType;
import org.drools.planner.benchmark.core.statistic.SingleStatistic;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseMeasurement;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseSingleStatistic;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseSingleStatisticPoint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MemoryUseProblemStatistic
extends AbstractProblemStatistic {
    protected File graphStatisticFile = null;

    public MemoryUseProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.MEMORY_USE);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new MemoryUseSingleStatistic();
    }

    public String getGraphFilePath() {
        return this.toFilePath(this.graphStatisticFile);
    }

    @Override
    protected void writeCsvStatistic() {
        AbstractProblemStatistic.ProblemStatisticCsv csv = new AbstractProblemStatistic.ProblemStatisticCsv(this);
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            if (singleBenchmark.isSuccess()) {
                MemoryUseSingleStatistic singleStatistic = (MemoryUseSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (MemoryUseSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    MemoryUseMeasurement memoryUseMeasurement = point.getMemoryUseMeasurement();
                    csv.addPoint(singleBenchmark, timeMillisSpend, Long.toString(memoryUseMeasurement.getUsedMemory()) + "/" + Long.toString(memoryUseMeasurement.getMaxMemory()));
                }
                continue;
            }
            csv.addPoint(singleBenchmark, 0L, "Failed");
        }
        this.csvStatisticFile = new File(this.problemBenchmark.getProblemReportDirectory(), this.problemBenchmark.getName() + "MemoryUseStatistic.csv");
        csv.writeCsvStatisticFile();
    }

    @Override
    protected void writeGraphStatistic() {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Memory");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            XYSeries usedSeries = new XYSeries((Comparable)((Object)(singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix() + " used")));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            if (singleBenchmark.isSuccess()) {
                MemoryUseSingleStatistic singleStatistic = (MemoryUseSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (MemoryUseSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    MemoryUseMeasurement memoryUseMeasurement = point.getMemoryUseMeasurement();
                    usedSeries.add((double)timeMillisSpend, (double)memoryUseMeasurement.getUsedMemory());
                }
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(usedSeries);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " memory use statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphStatisticFile = this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "MemoryUseStatistic");
    }

    @Override
    protected void fillWarningList() {
        if (this.problemBenchmark.getPlannerBenchmark().hasMultipleParallelBenchmarks()) {
            this.warningList.add("This memory use statistic shows the sum of the memory of all benchmarks that ran in parallel, due to parallelBenchmarkCount (" + this.problemBenchmark.getPlannerBenchmark().getParallelBenchmarkCount() + ").");
        }
    }
}

