/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic.memoryuse;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.core.statistic.AbstractSingleStatistic;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseMeasurement;
import org.drools.planner.benchmark.core.statistic.memoryuse.MemoryUseSingleStatisticPoint;
import org.drools.planner.core.Solver;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolver;

public class MemoryUseSingleStatistic
extends AbstractSingleStatistic {
    private MemoryUseSingleStatisticListener listener = new MemoryUseSingleStatisticListener();
    private long timeMillisThresholdInterval;
    private long nextTimeMillisThreshold;
    private List<MemoryUseSingleStatisticPoint> pointList = new ArrayList<MemoryUseSingleStatisticPoint>();

    public MemoryUseSingleStatistic() {
        this(1000L);
    }

    public MemoryUseSingleStatistic(long timeMillisThresholdInterval) {
        if (timeMillisThresholdInterval <= 0L) {
            throw new IllegalArgumentException("The timeMillisThresholdInterval (" + timeMillisThresholdInterval + ") must be bigger than 0.");
        }
        this.timeMillisThresholdInterval = timeMillisThresholdInterval;
        this.nextTimeMillisThreshold = timeMillisThresholdInterval;
    }

    public List<MemoryUseSingleStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    private class MemoryUseSingleStatisticListener
    extends SolverPhaseLifecycleListenerAdapter {
        private MemoryUseSingleStatisticListener() {
        }

        public void stepEnded(AbstractStepScope stepScope) {
            long timeMillisSpend = stepScope.getPhaseScope().calculateSolverTimeMillisSpend();
            if (timeMillisSpend >= MemoryUseSingleStatistic.this.nextTimeMillisThreshold) {
                MemoryUseSingleStatistic.this.pointList.add(new MemoryUseSingleStatisticPoint(timeMillisSpend, MemoryUseMeasurement.create()));
                MemoryUseSingleStatistic.this.nextTimeMillisThreshold += MemoryUseSingleStatistic.this.timeMillisThresholdInterval;
                if (MemoryUseSingleStatistic.this.nextTimeMillisThreshold < timeMillisSpend) {
                    MemoryUseSingleStatistic.this.nextTimeMillisThreshold = timeMillisSpend;
                }
            }
        }
    }
}

