package org.drools.planner.benchmark;

import java.util.Comparator;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.core.score.Score;

/**
 * @author Geoffrey De Smet
 */
public class TotalScoreSolverBenchmarkComparator implements Comparator<SolverBenchmark> {

    private WorstScoreSolverBenchmarkComparator worstScoreSolverBenchmarkComparator
            = new WorstScoreSolverBenchmarkComparator();

    public int compare(SolverBenchmark a, SolverBenchmark b) {
        return new CompareToBuilder()
                .append(a.getTotalScore(), b.getTotalScore())
                .append(a, b, worstScoreSolverBenchmarkComparator)
                .toComparison();
    }

}
