/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.deciderscorecomparator;

import junit.framework.TestCase;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.HardPenaltyDeciderScoreComparator;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.ShiftingHardPenaltyDeciderScoreComparatorFactory;
import org.drools.planner.core.score.DefaultHardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.comparator.NaturalScoreComparator;
import org.drools.planner.core.score.definition.HardAndSoftScoreDefinition;
import org.drools.planner.core.score.definition.ScoreDefinition;

public class ShiftingHardPenaltyDeciderScoreComparatorFactoryTest
extends TestCase {
    public void testShiftingPenaltyActiveAndHardWeight() {
        ShiftingHardPenaltyDeciderScoreComparatorFactory deciderScoreComparatorFactory = new ShiftingHardPenaltyDeciderScoreComparatorFactory();
        deciderScoreComparatorFactory.setHardScoreActivationThreshold(-10);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMinimum(1);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeMaximum(3);
        deciderScoreComparatorFactory.setSuccessiveNoHardChangeRepetitionMultiplicand(5.0);
        deciderScoreComparatorFactory.setHardWeightSurvivalRatio(0.9);
        LocalSearchSolverScope localSearchSolverScope = this.createLocalSearchSolverScope();
        deciderScoreComparatorFactory.solvingStarted(localSearchSolverScope);
        StepScope stepScope = localSearchSolverScope.getLastCompletedStepScope();
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-11, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        localSearchSolverScope.setBestSolutionStepIndex(stepScope.getStepIndex());
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertEquals((int)1000, (int)((HardPenaltyDeciderScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertEquals((int)900, (int)((HardPenaltyDeciderScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertEquals((int)810, (int)((HardPenaltyDeciderScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertTrue((boolean)(deciderScoreComparatorFactory.createDeciderScoreComparator() instanceof NaturalScoreComparator));
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
        stepScope = this.nextStepScope(stepScope);
        deciderScoreComparatorFactory.beforeDeciding(stepScope);
        ShiftingHardPenaltyDeciderScoreComparatorFactoryTest.assertEquals((int)1000, (int)((HardPenaltyDeciderScoreComparator)deciderScoreComparatorFactory.createDeciderScoreComparator()).getHardWeight());
        deciderScoreComparatorFactory.stepDecided(stepScope);
        stepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-10, (int)-200));
        deciderScoreComparatorFactory.stepTaken(stepScope);
    }

    private StepScope nextStepScope(StepScope lastStepScope) {
        StepScope stepScope = new StepScope(lastStepScope.getLocalSearchSolverScope());
        lastStepScope.getLocalSearchSolverScope().setLastCompletedStepScope(lastStepScope);
        stepScope.setStepIndex(lastStepScope.getStepIndex() + 1);
        return stepScope;
    }

    private LocalSearchSolverScope createLocalSearchSolverScope() {
        LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();
        localSearchSolverScope.setScoreDefinition((ScoreDefinition)new HardAndSoftScoreDefinition());
        localSearchSolverScope.setBestScore((Score)DefaultHardAndSoftScore.valueOf((int)-11, (int)-200));
        localSearchSolverScope.setBestSolutionStepIndex(1000);
        StepScope lastStepScope = new StepScope(localSearchSolverScope);
        lastStepScope.setStepIndex(1000);
        lastStepScope.setScore((Score)DefaultHardAndSoftScore.valueOf((int)-11, (int)-200));
        localSearchSolverScope.setLastCompletedStepScope(lastStepScope);
        return localSearchSolverScope;
    }
}

