/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.drools.planner.benchmark.SolverBenchmarkResult;
import org.drools.planner.config.localsearch.LocalSearchSolverConfig;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="solverBenchmark")
public class SolverBenchmark {
    private String name = null;
    @XStreamAlias(value="localSearchSolver")
    private LocalSearchSolverConfig localSearchSolverConfig = null;
    @XStreamImplicit(itemFieldName="unsolvedSolutionFile")
    private List<File> unsolvedSolutionFileList = null;
    @XStreamImplicit(itemFieldName="solverBenchmarkResult")
    private List<SolverBenchmarkResult> solverBenchmarkResultList = null;
    private Integer ranking = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalSearchSolverConfig getLocalSearchSolverConfig() {
        return this.localSearchSolverConfig;
    }

    public void setLocalSearchSolverConfig(LocalSearchSolverConfig localSearchSolverConfig) {
        this.localSearchSolverConfig = localSearchSolverConfig;
    }

    public List<File> getUnsolvedSolutionFileList() {
        return this.unsolvedSolutionFileList;
    }

    public void setUnsolvedSolutionFileList(List<File> unsolvedSolutionFileList) {
        this.unsolvedSolutionFileList = unsolvedSolutionFileList;
    }

    public List<SolverBenchmarkResult> getSolverBenchmarkResultList() {
        return this.solverBenchmarkResultList;
    }

    public void setSolverBenchmarkResultList(List<SolverBenchmarkResult> solverBenchmarkResultList) {
        this.solverBenchmarkResultList = solverBenchmarkResultList;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public void inheritLocalSearchSolverConfig(LocalSearchSolverConfig inheritedLocalSearchSolverConfig) {
        if (this.localSearchSolverConfig == null) {
            this.localSearchSolverConfig = inheritedLocalSearchSolverConfig;
        } else {
            this.localSearchSolverConfig.inherit(inheritedLocalSearchSolverConfig);
        }
    }

    public void inheritUnsolvedSolutionFileList(List<File> inheritedUnsolvedSolutionFileList) {
        SolverBenchmarkResult result;
        ArrayList<File> filesWithResult = new ArrayList<File>();
        if (this.solverBenchmarkResultList != null) {
            for (SolverBenchmarkResult result2 : this.solverBenchmarkResultList) {
                filesWithResult.add(result2.getUnsolvedSolutionFile());
            }
        } else {
            this.solverBenchmarkResultList = new ArrayList<SolverBenchmarkResult>();
        }
        if (this.unsolvedSolutionFileList != null) {
            for (File unsolvedSolutionFile : this.unsolvedSolutionFileList) {
                if (filesWithResult.contains(unsolvedSolutionFile)) continue;
                result = new SolverBenchmarkResult();
                result.setUnsolvedSolutionFile(unsolvedSolutionFile);
                this.solverBenchmarkResultList.add(result);
                filesWithResult.add(unsolvedSolutionFile);
            }
        }
        if (inheritedUnsolvedSolutionFileList != null) {
            for (File inheritedUnsolvedSolutionFile : inheritedUnsolvedSolutionFileList) {
                if (filesWithResult.contains(inheritedUnsolvedSolutionFile)) continue;
                result = new SolverBenchmarkResult();
                result.setUnsolvedSolutionFile(inheritedUnsolvedSolutionFile);
                this.solverBenchmarkResultList.add(result);
                filesWithResult.add(inheritedUnsolvedSolutionFile);
            }
        }
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.solverBenchmarkResultList.size());
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            scoreList.add(solverBenchmarkResult.getScore());
        }
        return scoreList;
    }

    public Score getTotalScore() {
        Score totalScore = null;
        for (SolverBenchmarkResult solverBenchmarkResult : this.solverBenchmarkResultList) {
            if (totalScore == null) {
                totalScore = solverBenchmarkResult.getScore();
                continue;
            }
            totalScore = totalScore.add(solverBenchmarkResult.getScore());
        }
        return totalScore;
    }

    public Score getAverageScore() {
        return this.getTotalScore().divide(this.solverBenchmarkResultList.size());
    }
}

