/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.SolverBenchmark;
import org.drools.planner.benchmark.SolverBenchmarkResult;
import org.drools.planner.benchmark.TotalScoreSolverBenchmarkComparator;
import org.drools.planner.benchmark.statistic.BestScoreStatistic;
import org.drools.planner.benchmark.statistic.SolverStatistic;
import org.drools.planner.config.localsearch.LocalSearchSolverConfig;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="solverBenchmarkSuite")
public class SolverBenchmarkSuite {
    public static final NumberFormat TIME_FORMAT = NumberFormat.getIntegerInstance(Locale.ENGLISH);
    private File benchmarkDirectory = null;
    private File solvedSolutionFilesDirectory = null;
    private File solverStatisticFilesDirectory = null;
    private SolverStatisticType solverStatisticType = SolverStatisticType.NONE;
    private Comparator<SolverBenchmark> solverBenchmarkComparator = null;
    @XStreamAlias(value="inheritedLocalSearchSolver")
    private LocalSearchSolverConfig inheritedLocalSearchSolverConfig = null;
    @XStreamImplicit(itemFieldName="inheritedUnsolvedSolutionFile")
    private List<File> inheritedUnsolvedSolutionFileList = null;
    @XStreamImplicit(itemFieldName="solverBenchmark")
    private List<SolverBenchmark> solverBenchmarkList = null;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public File getSolvedSolutionFilesDirectory() {
        return this.solvedSolutionFilesDirectory;
    }

    public void setSolvedSolutionFilesDirectory(File solvedSolutionFilesDirectory) {
        this.solvedSolutionFilesDirectory = solvedSolutionFilesDirectory;
    }

    public File getSolverStatisticFilesDirectory() {
        return this.solverStatisticFilesDirectory;
    }

    public void setSolverStatisticFilesDirectory(File solverStatisticFilesDirectory) {
        this.solverStatisticFilesDirectory = solverStatisticFilesDirectory;
    }

    public SolverStatisticType getSolverStatisticType() {
        return this.solverStatisticType;
    }

    public void setSolverStatisticType(SolverStatisticType solverStatisticType) {
        this.solverStatisticType = solverStatisticType;
    }

    public Comparator<SolverBenchmark> getSolverBenchmarkComparator() {
        return this.solverBenchmarkComparator;
    }

    public void setSolverBenchmarkComparator(Comparator<SolverBenchmark> solverBenchmarkComparator) {
        this.solverBenchmarkComparator = solverBenchmarkComparator;
    }

    public LocalSearchSolverConfig getInheritedLocalSearchSolverConfig() {
        return this.inheritedLocalSearchSolverConfig;
    }

    public void setInheritedLocalSearchSolverConfig(LocalSearchSolverConfig inheritedLocalSearchSolverConfig) {
        this.inheritedLocalSearchSolverConfig = inheritedLocalSearchSolverConfig;
    }

    public List<File> getInheritedUnsolvedSolutionFileList() {
        return this.inheritedUnsolvedSolutionFileList;
    }

    public void setInheritedUnsolvedSolutionFileList(List<File> inheritedUnsolvedSolutionFileList) {
        this.inheritedUnsolvedSolutionFileList = inheritedUnsolvedSolutionFileList;
    }

    public List<SolverBenchmark> getSolverBenchmarkList() {
        return this.solverBenchmarkList;
    }

    public void setSolverBenchmarkList(List<SolverBenchmark> solverBenchmarkList) {
        this.solverBenchmarkList = solverBenchmarkList;
    }

    public void benchmarkingStarted() {
        HashSet<String> nameSet = new HashSet<String>(this.solverBenchmarkList.size());
        LinkedHashSet<SolverBenchmark> noNameBenchmarkSet = new LinkedHashSet<SolverBenchmark>(this.solverBenchmarkList.size());
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            if (solverBenchmark.getName() != null) {
                boolean unique = nameSet.add(solverBenchmark.getName());
                if (!unique) {
                    throw new IllegalStateException("The benchmark name (" + solverBenchmark.getName() + ") is used in more than 1 benchmark.");
                }
            } else {
                noNameBenchmarkSet.add(solverBenchmark);
            }
            if (this.inheritedLocalSearchSolverConfig != null) {
                solverBenchmark.inheritLocalSearchSolverConfig(this.inheritedLocalSearchSolverConfig);
            }
            if (this.inheritedUnsolvedSolutionFileList == null) continue;
            solverBenchmark.inheritUnsolvedSolutionFileList(this.inheritedUnsolvedSolutionFileList);
        }
        int generatedNameIndex = 0;
        for (SolverBenchmark solverBenchmark : noNameBenchmarkSet) {
            String generatedName = "Config_" + generatedNameIndex;
            while (nameSet.contains(generatedName)) {
                generatedName = "Config_" + ++generatedNameIndex;
            }
            solverBenchmark.setName(generatedName);
            ++generatedNameIndex;
        }
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        if (this.solvedSolutionFilesDirectory == null) {
            this.solvedSolutionFilesDirectory = new File(this.benchmarkDirectory, "solved");
        }
        this.solvedSolutionFilesDirectory.mkdirs();
        if (this.solverStatisticFilesDirectory == null) {
            this.solverStatisticFilesDirectory = new File(this.benchmarkDirectory, "statistic");
        }
        this.solverStatisticFilesDirectory.mkdirs();
        if (this.solverBenchmarkComparator == null) {
            this.solverBenchmarkComparator = new TotalScoreSolverBenchmarkComparator();
        }
    }

    public void benchmark(XStream xStream) {
        this.benchmarkingStarted();
        LinkedHashMap<File, SolverStatistic> unsolvedSolutionFileToStatisticMap = new LinkedHashMap<File, SolverStatistic>();
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            LocalSearchSolver solver = solverBenchmark.getLocalSearchSolverConfig().buildSolver();
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                File unsolvedSolutionFile = result.getUnsolvedSolutionFile();
                Solution unsolvedSolution = this.readUnsolvedSolution(xStream, unsolvedSolutionFile);
                solver.setStartingSolution(unsolvedSolution);
                if (this.solverStatisticType != SolverStatisticType.NONE) {
                    SolverStatistic statistic = (SolverStatistic)unsolvedSolutionFileToStatisticMap.get(unsolvedSolutionFile);
                    if (statistic == null) {
                        statistic = this.solverStatisticType.create();
                        unsolvedSolutionFileToStatisticMap.put(unsolvedSolutionFile, statistic);
                    }
                    statistic.addListener(solver, solverBenchmark.getName());
                }
                solver.solve();
                result.setTimeMillisSpend(solver.getTimeMillisSpend());
                Solution solvedSolution = solver.getBestSolution();
                result.setScore(solvedSolution.getScore());
                if (this.solverStatisticType != SolverStatisticType.NONE) {
                    SolverStatistic statistic = (SolverStatistic)unsolvedSolutionFileToStatisticMap.get(unsolvedSolutionFile);
                    statistic.removeListener(solver, solverBenchmark.getName());
                }
                this.writeSolvedSolution(xStream, solverBenchmark, result, solvedSolution);
            }
        }
        this.benchmarkingEnded(xStream, unsolvedSolutionFileToStatisticMap);
    }

    private Solution readUnsolvedSolution(XStream xStream, File unsolvedSolutionFile) {
        Solution unsolvedSolution;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(unsolvedSolutionFile), "utf-8");
            unsolvedSolution = (Solution)xStream.fromXML((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem reading unsolvedSolutionFile: " + unsolvedSolutionFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return unsolvedSolution;
    }

    private void writeSolvedSolution(XStream xStream, SolverBenchmark solverBenchmark, SolverBenchmarkResult result, Solution solvedSolution) {
        if (this.solvedSolutionFilesDirectory == null) {
            return;
        }
        File solvedSolutionFile = null;
        String baseName = FilenameUtils.getBaseName((String)result.getUnsolvedSolutionFile().getName());
        String solverBenchmarkName = solverBenchmark.getName().replaceAll(" ", "_").replaceAll("[^\\w\\d_\\-]", "");
        String scoreString = result.getScore().toString().replaceAll("[\\/ ]", "_");
        String timeString = TIME_FORMAT.format(result.getTimeMillisSpend()) + "ms";
        solvedSolutionFile = new File(this.solvedSolutionFilesDirectory, baseName + "_" + solverBenchmarkName + "_score" + scoreString + "_time" + timeString + ".xml");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(solvedSolutionFile), "utf-8");
            xStream.toXML((Object)solvedSolution, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing solvedSolutionFile: " + solvedSolutionFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void benchmarkingEnded(XStream xStream, Map<File, SolverStatistic> unsolvedSolutionFileToStatisticMap) {
        this.determineRankings();
        this.writeBestScoreSummaryChart();
        StringBuilder htmlFragment = new StringBuilder(unsolvedSolutionFileToStatisticMap.size() * 160);
        htmlFragment.append("  <h1>Summary</h1>\n");
        htmlFragment.append("  <h2>Summary chart</h2>\n");
        htmlFragment.append(this.writeBestScoreSummaryChart());
        htmlFragment.append("  <h2>Summary table</h2>\n");
        htmlFragment.append(this.writeBestScoreSummaryTable());
        htmlFragment.append("  <h1>Statistic ").append(this.solverStatisticType.toString()).append("</h1>\n");
        for (Map.Entry<File, SolverStatistic> entry : unsolvedSolutionFileToStatisticMap.entrySet()) {
            File unsolvedSolutionFile = entry.getKey();
            SolverStatistic statistic = entry.getValue();
            String baseName = FilenameUtils.getBaseName((String)unsolvedSolutionFile.getName());
            htmlFragment.append("  <h2>").append(baseName).append("</h2>\n");
            htmlFragment.append(statistic.writeStatistic(this.solverStatisticFilesDirectory, baseName));
        }
        this.writeHtmlOverview(htmlFragment);
        this.writeBenchmarkResult(xStream);
    }

    private void determineRankings() {
        ArrayList<SolverBenchmark> sortedSolverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkList);
        Collections.sort(sortedSolverBenchmarkList, this.solverBenchmarkComparator);
        Collections.reverse(sortedSolverBenchmarkList);
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.setRanking(sortedSolverBenchmarkList.indexOf(solverBenchmark));
        }
    }

    private CharSequence writeBestScoreSummaryChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            ScoreDefinition scoreDefinition = solverBenchmark.getLocalSearchSolverConfig().getScoreDefinitionConfig().buildScoreDefinition();
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                Score score = result.getScore();
                Double scoreGraphValue = scoreDefinition.translateScoreToGraphValue(score);
                String solverLabel = solverBenchmark.getName();
                if (solverBenchmark.getRanking() == 0) {
                    solverLabel = solverLabel + " (winner)";
                }
                dataset.addValue((Number)scoreGraphValue, (Comparable)((Object)solverLabel), (Comparable)((Object)result.getUnsolvedSolutionFile().getName()));
            }
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"Best score summary (higher score is better)", (String)"Data", (String)"Score", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryItemRenderer renderer = ((CategoryPlot)chart.getPlot()).getRenderer();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)generator);
        renderer.setBaseItemLabelsVisible(true);
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File chartSummaryFile = new File(this.solverStatisticFilesDirectory, "summary.png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chartSummaryFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing graphStatisticFile: " + chartSummaryFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return "  <img src=\"" + chartSummaryFile.getName() + "\"/>\n";
    }

    private CharSequence writeBestScoreSummaryTable() {
        StringBuilder htmlFragment = new StringBuilder(this.solverBenchmarkList.size() * 160);
        htmlFragment.append("  <table border=\"1\">\n");
        htmlFragment.append("    <tr><th/>");
        for (File unsolvedSolutionFile : this.inheritedUnsolvedSolutionFileList) {
            htmlFragment.append("<th>").append(unsolvedSolutionFile.getName()).append("</th>");
        }
        htmlFragment.append("<th>Average</th><th>Ranking</th></tr>\n");
        boolean oddLine = true;
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            String backgroundColor = solverBenchmark.getRanking() == 0 ? "Yellow" : (oddLine ? "White" : "Gray");
            htmlFragment.append("    <tr style=\"background-color: ").append(backgroundColor).append("\"><th>").append(solverBenchmark.getName()).append("</th>");
            for (SolverBenchmarkResult result : solverBenchmark.getSolverBenchmarkResultList()) {
                Score score = result.getScore();
                htmlFragment.append("<td>").append(score.toString()).append("</td>");
            }
            htmlFragment.append("<td>").append(solverBenchmark.getAverageScore().toString()).append("</td><td>").append(solverBenchmark.getRanking()).append("</td>");
            htmlFragment.append("</tr>\n");
            oddLine = !oddLine;
        }
        htmlFragment.append("  </table>\n");
        return htmlFragment.toString();
    }

    private void writeHtmlOverview(CharSequence htmlFragment) {
        File htmlOverviewFile = new File(this.solverStatisticFilesDirectory, "index.html");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlOverviewFile), "utf-8");
            ((Writer)writer).append("<html>\n");
            ((Writer)writer).append("<head>\n");
            ((Writer)writer).append("  <title>Statistic</title>\n");
            ((Writer)writer).append("</head>\n");
            ((Writer)writer).append("<body>\n");
            ((Writer)writer).append(htmlFragment);
            ((Writer)writer).append("</body>\n");
            ((Writer)writer).append("</html>\n");
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing htmlOverviewFile: " + htmlOverviewFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBenchmarkResult(XStream xStream) {
        File benchmarkResultFile = new File(this.benchmarkDirectory, "benchmarkResult.xml");
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(benchmarkResultFile), "utf-8");
            xStream.toXML((Object)this, (Writer)writer);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This JVM does not support utf-8 encoding.", e);
                catch (FileNotFoundException e2) {
                    throw new IllegalArgumentException("Could not create benchmarkResultFile (" + benchmarkResultFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SolverStatisticType {
        NONE,
        BEST_SOLUTION_CHANGED;


        public SolverStatistic create() {
            switch (this) {
                case NONE: {
                    return null;
                }
                case BEST_SOLUTION_CHANGED: {
                    return new BestScoreStatistic();
                }
            }
            throw new IllegalStateException("The solverStatisticType (" + (Object)((Object)this) + ") is not implemented");
        }
    }
}

