/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.Annotations;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NativeFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;
import org.drools.planner.config.localsearch.LocalSearchSolverConfig;
import org.drools.planner.core.localsearch.LocalSearchSolver;

public class XmlSolverConfigurer {
    private XStream xStream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new NativeFieldKeySorter())));
    private LocalSearchSolverConfig config = null;

    public XmlSolverConfigurer() {
        this.xStream.setMode(1002);
        Annotations.configureAliases((XStream)this.xStream, (Class[])new Class[]{LocalSearchSolverConfig.class});
    }

    public XmlSolverConfigurer(String resource) {
        this();
        this.configure(resource);
    }

    public void addXstreamAlias(Class aliasClass) {
        Annotations.configureAliases((XStream)this.xStream, (Class[])new Class[]{aliasClass});
    }

    public LocalSearchSolverConfig getConfig() {
        return this.config;
    }

    public XmlSolverConfigurer configure(String resource) {
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new IllegalArgumentException("The solver configuration (" + resource + ") does not exist.");
        }
        return this.configure(in);
    }

    public XmlSolverConfigurer configure(InputStream in) {
        XmlSolverConfigurer xmlSolverConfigurer;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(in, "utf-8");
            xmlSolverConfigurer = this.configure(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new IllegalStateException("This vm does not support utf-8 encoding.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return xmlSolverConfigurer;
    }

    public XmlSolverConfigurer configure(Reader reader) {
        this.config = (LocalSearchSolverConfig)this.xStream.fromXML(reader);
        return this;
    }

    public LocalSearchSolver buildSolver() {
        return this.config.buildSolver();
    }
}

