/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.planner.config.localsearch.decider.acceptor.AcceptorConfig;
import org.drools.planner.config.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactoryConfig;
import org.drools.planner.config.localsearch.decider.forager.ForagerConfig;
import org.drools.planner.config.localsearch.decider.selector.SelectorConfig;
import org.drools.planner.config.localsearch.termination.TerminationConfig;
import org.drools.planner.config.score.definition.ScoreDefinitionConfig;
import org.drools.planner.core.localsearch.DefaultLocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.DefaultDecider;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.initializer.StartingSolutionInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="localSearchSolver")
public class LocalSearchSolverConfig {
    private static final long DEFAULT_RANDOM_SEED = 0L;
    private EnvironmentMode environmentMode = null;
    private Long randomSeed = null;
    @XStreamImplicit(itemFieldName="scoreDrl")
    private List<String> scoreDrlList = null;
    @XStreamAlias(value="scoreDefinition")
    private ScoreDefinitionConfig scoreDefinitionConfig = new ScoreDefinitionConfig();
    private StartingSolutionInitializer startingSolutionInitializer = null;
    private Class<StartingSolutionInitializer> startingSolutionInitializerClass = null;
    @XStreamAlias(value="termination")
    private TerminationConfig terminationConfig = new TerminationConfig();
    @XStreamAlias(value="deciderScoreComparatorFactory")
    private DeciderScoreComparatorFactoryConfig deciderScoreComparatorFactoryConfig = new DeciderScoreComparatorFactoryConfig();
    @XStreamAlias(value="selector")
    private SelectorConfig selectorConfig = new SelectorConfig();
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = new AcceptorConfig();
    @XStreamAlias(value="forager")
    private ForagerConfig foragerConfig = new ForagerConfig();

    public EnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(EnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public List<String> getScoreDrlList() {
        return this.scoreDrlList;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList;
    }

    public ScoreDefinitionConfig getScoreDefinitionConfig() {
        return this.scoreDefinitionConfig;
    }

    public void setScoreDefinitionConfig(ScoreDefinitionConfig scoreDefinitionConfig) {
        this.scoreDefinitionConfig = scoreDefinitionConfig;
    }

    public StartingSolutionInitializer getStartingSolutionInitializer() {
        return this.startingSolutionInitializer;
    }

    public void setStartingSolutionInitializer(StartingSolutionInitializer startingSolutionInitializer) {
        this.startingSolutionInitializer = startingSolutionInitializer;
    }

    public Class<StartingSolutionInitializer> getStartingSolutionInitializerClass() {
        return this.startingSolutionInitializerClass;
    }

    public void setStartingSolutionInitializerClass(Class<StartingSolutionInitializer> startingSolutionInitializerClass) {
        this.startingSolutionInitializerClass = startingSolutionInitializerClass;
    }

    public TerminationConfig getTerminationConfig() {
        return this.terminationConfig;
    }

    public void setTerminationConfig(TerminationConfig terminationConfig) {
        this.terminationConfig = terminationConfig;
    }

    public DeciderScoreComparatorFactoryConfig getDeciderScoreComparatorFactoryConfig() {
        return this.deciderScoreComparatorFactoryConfig;
    }

    public void setDeciderScoreComparatorFactoryConfig(DeciderScoreComparatorFactoryConfig deciderScoreComparatorFactoryConfig) {
        this.deciderScoreComparatorFactoryConfig = deciderScoreComparatorFactoryConfig;
    }

    public SelectorConfig getSelectorConfig() {
        return this.selectorConfig;
    }

    public void setSelectorConfig(SelectorConfig selectorConfig) {
        this.selectorConfig = selectorConfig;
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public ForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    public LocalSearchSolver buildSolver() {
        DefaultLocalSearchSolver localSearchSolver = new DefaultLocalSearchSolver();
        if (this.environmentMode != EnvironmentMode.PRODUCTION) {
            if (this.randomSeed != null) {
                localSearchSolver.setRandomSeed(this.randomSeed);
            } else {
                localSearchSolver.setRandomSeed(0L);
            }
        }
        localSearchSolver.setRuleBase(this.buildRuleBase());
        ScoreDefinition scoreDefinition = this.scoreDefinitionConfig.buildScoreDefinition();
        localSearchSolver.setScoreDefinition(scoreDefinition);
        localSearchSolver.setScoreCalculator(this.scoreDefinitionConfig.buildScoreCalculator());
        localSearchSolver.setStartingSolutionInitializer(this.buildStartingSolutionInitializer());
        localSearchSolver.setBestSolutionRecaller(new BestSolutionRecaller());
        localSearchSolver.setTermination(this.terminationConfig.buildTermination(scoreDefinition));
        localSearchSolver.setDecider(this.buildDecider());
        if (this.environmentMode == EnvironmentMode.DEBUG) {
            localSearchSolver.setAssertStepScoreIsUncorrupted(true);
        }
        return localSearchSolver;
    }

    private RuleBase buildRuleBase() {
        PackageBuilder packageBuilder = new PackageBuilder();
        for (String scoreDrl : this.scoreDrlList) {
            InputStream scoreDrlIn = this.getClass().getResourceAsStream(scoreDrl);
            if (scoreDrlIn == null) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") does not exist as a classpath resource.");
            }
            try {
                packageBuilder.addPackageFromDrl((Reader)new InputStreamReader(scoreDrlIn, "utf-8"));
            }
            catch (DroolsParserException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("scoreDrl (" + scoreDrl + ") could not be loaded.", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)scoreDrlIn);
            }
        }
        RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)ruleBaseConfiguration);
        if (packageBuilder.hasErrors()) {
            throw new IllegalStateException("There are errors in the scoreDrl's:" + packageBuilder.getErrors().toString());
        }
        ruleBase.addPackage(packageBuilder.getPackage());
        return ruleBase;
    }

    public StartingSolutionInitializer buildStartingSolutionInitializer() {
        if (this.startingSolutionInitializer != null) {
            return this.startingSolutionInitializer;
        }
        if (this.startingSolutionInitializerClass != null) {
            try {
                return this.startingSolutionInitializerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("startingSolutionInitializerClass (" + this.startingSolutionInitializerClass.getName() + ") does not have a public no-arg constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("startingSolutionInitializerClass (" + this.startingSolutionInitializerClass.getName() + ") does not have a public no-arg constructor", e);
            }
        }
        return null;
    }

    private Decider buildDecider() {
        DefaultDecider decider = new DefaultDecider();
        decider.setDeciderScoreComparator(this.deciderScoreComparatorFactoryConfig.buildDeciderScoreComparatorFactory());
        decider.setSelector(this.selectorConfig.buildSelector());
        decider.setAcceptor(this.acceptorConfig.buildAcceptor());
        decider.setForager(this.foragerConfig.buildForager());
        if (this.environmentMode == EnvironmentMode.DEBUG) {
            decider.setAssertUndoMoveIsUncorrupted(true);
        }
        return decider;
    }

    public void inherit(LocalSearchSolverConfig inheritedConfig) {
        if (this.environmentMode == null) {
            this.environmentMode = inheritedConfig.getEnvironmentMode();
        }
        if (this.randomSeed == null) {
            this.randomSeed = inheritedConfig.getRandomSeed();
        }
        if (this.scoreDrlList == null) {
            this.scoreDrlList = inheritedConfig.getScoreDrlList();
        } else {
            List<String> inheritedScoreDrlList = inheritedConfig.getScoreDrlList();
            if (inheritedScoreDrlList != null) {
                for (String inheritedScoreDrl : inheritedScoreDrlList) {
                    if (this.scoreDrlList.contains(inheritedScoreDrl)) continue;
                    this.scoreDrlList.add(inheritedScoreDrl);
                }
            }
        }
        if (this.scoreDefinitionConfig == null) {
            this.scoreDefinitionConfig = inheritedConfig.getScoreDefinitionConfig();
        } else if (inheritedConfig.getScoreDefinitionConfig() != null) {
            this.scoreDefinitionConfig.inherit(inheritedConfig.getScoreDefinitionConfig());
        }
        if (this.startingSolutionInitializer == null && this.startingSolutionInitializerClass == null) {
            this.startingSolutionInitializer = inheritedConfig.getStartingSolutionInitializer();
            this.startingSolutionInitializerClass = inheritedConfig.getStartingSolutionInitializerClass();
        }
        if (this.terminationConfig == null) {
            this.terminationConfig = inheritedConfig.getTerminationConfig();
        } else if (inheritedConfig.getTerminationConfig() != null) {
            this.terminationConfig.inherit(inheritedConfig.getTerminationConfig());
        }
        if (this.deciderScoreComparatorFactoryConfig == null) {
            this.deciderScoreComparatorFactoryConfig = inheritedConfig.getDeciderScoreComparatorFactoryConfig();
        } else if (inheritedConfig.getDeciderScoreComparatorFactoryConfig() != null) {
            this.deciderScoreComparatorFactoryConfig.inherit(inheritedConfig.getDeciderScoreComparatorFactoryConfig());
        }
        if (this.selectorConfig == null) {
            this.selectorConfig = inheritedConfig.getSelectorConfig();
        } else if (inheritedConfig.getSelectorConfig() != null) {
            this.selectorConfig.inherit(inheritedConfig.getSelectorConfig());
        }
        if (this.acceptorConfig == null) {
            this.acceptorConfig = inheritedConfig.getAcceptorConfig();
        } else if (inheritedConfig.getAcceptorConfig() != null) {
            this.acceptorConfig.inherit(inheritedConfig.getAcceptorConfig());
        }
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnvironmentMode {
        DEBUG,
        REPRODUCIBLE,
        PRODUCTION;

    }
}

