/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.score;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.drools.planner.core.score.DefaultHardAndSoftScore;
import org.drools.planner.core.score.DefaultSimpleScore;

@XStreamAlias(value="score")
public class ScoreConfig {
    private Comparable score = null;
    private ScoreType scoreType = null;
    private String scoreString;

    public Comparable getScore() {
        return this.score;
    }

    public void setScore(Comparable score) {
        this.score = score;
    }

    public ScoreType getScoreType() {
        return this.scoreType;
    }

    public void setScoreType(ScoreType scoreType) {
        this.scoreType = scoreType;
    }

    public String getScoreString() {
        return this.scoreString;
    }

    public void setScoreString(String scoreString) {
        this.scoreString = scoreString;
    }

    public Comparable buildScore() {
        if (this.score != null) {
            return this.score;
        }
        if (this.scoreType != null) {
            switch (this.scoreType) {
                case SIMPLE: {
                    return DefaultSimpleScore.parseScore(this.scoreString);
                }
                case HARD_AND_SOFT: {
                    return DefaultHardAndSoftScore.parseScore(this.scoreString);
                }
            }
            throw new IllegalStateException("The scoreType (" + (Object)((Object)this.scoreType) + ") is not implemented");
        }
        return null;
    }

    public void inherit(ScoreConfig inheritedConfig) {
        if (this.score == null && this.scoreType == null && this.scoreString == null) {
            this.score = inheritedConfig.getScore();
            this.scoreType = inheritedConfig.getScoreType();
            this.scoreString = inheritedConfig.getScoreString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoreType {
        SIMPLE,
        HARD_AND_SOFT;

    }
}

