/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core;

import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.planner.core.Solver;
import org.drools.planner.core.event.SolverEventListener;
import org.drools.planner.core.event.SolverEventSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolver
implements Solver {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverEventSupport solverEventSupport = new SolverEventSupport(this);
    protected final AtomicBoolean terminatedEarly = new AtomicBoolean(false);

    public boolean terminateEarly() {
        boolean terminationEarlySuccessful;
        boolean bl = terminationEarlySuccessful = !this.terminatedEarly.getAndSet(true);
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        return terminationEarlySuccessful;
    }

    public boolean isTerminatedEarly() {
        return this.terminatedEarly.get();
    }

    public final void solve() {
        this.terminatedEarly.set(false);
        this.solveImplementation();
    }

    protected abstract void solveImplementation();

    public void addEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    public void removeEventListener(SolverEventListener eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }
}

