/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import java.util.Random;
import org.drools.RuleBase;
import org.drools.planner.core.AbstractSolver;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolverLifecycleListener;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.termination.Termination;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.initializer.StartingSolutionInitializer;

public class DefaultLocalSearchSolver
extends AbstractSolver
implements LocalSearchSolver,
LocalSearchSolverLifecycleListener {
    protected Long randomSeed;
    protected StartingSolutionInitializer startingSolutionInitializer = null;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected Termination termination;
    protected Decider decider;
    protected boolean assertStepScoreIsUncorrupted = false;
    protected LocalSearchSolverScope localSearchSolverScope = new LocalSearchSolverScope();

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.localSearchSolverScope.setRuleBase(ruleBase);
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.localSearchSolverScope.setScoreDefinition(scoreDefinition);
    }

    public ScoreDefinition getScoreDefinition() {
        return this.localSearchSolverScope.getScoreDefinition();
    }

    public void setScoreCalculator(ScoreCalculator scoreCalculator) {
        this.localSearchSolverScope.setWorkingScoreCalculator(scoreCalculator);
    }

    public StartingSolutionInitializer getStartingSolutionInitializer() {
        return this.startingSolutionInitializer;
    }

    public void setStartingSolutionInitializer(StartingSolutionInitializer startingSolutionInitializer) {
        this.startingSolutionInitializer = startingSolutionInitializer;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.bestSolutionRecaller.setLocalSearchSolver(this);
        this.bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
        this.termination.setLocalSearchSolver(this);
    }

    public Decider getDecider() {
        return this.decider;
    }

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolver(this);
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void setStartingSolution(Solution startingSolution) {
        this.localSearchSolverScope.setWorkingSolution(startingSolution);
    }

    public Solution getBestSolution() {
        return this.localSearchSolverScope.getBestSolution();
    }

    public long getTimeMillisSpend() {
        return this.localSearchSolverScope.calculateTimeMillisSpend();
    }

    public LocalSearchSolverScope getLocalSearchSolverScope() {
        return this.localSearchSolverScope;
    }

    protected void solveImplementation() {
        LocalSearchSolverScope localSearchSolverScope = this.localSearchSolverScope;
        this.solvingStarted(localSearchSolverScope);
        StepScope stepScope = this.createNextStepScope(localSearchSolverScope, null);
        while (!this.terminatedEarly.get() && !this.termination.isTerminated(stepScope)) {
            stepScope.setTimeGradient(this.termination.calculateTimeGradient(stepScope));
            this.beforeDeciding(stepScope);
            this.decider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                this.logger.warn("No move accepted for step index ({}) out of {} accepted moves. Terminating by exception.", (Object)stepScope.getStepIndex(), (Object)this.decider.getForager().getAcceptedMovesSize());
                break;
            }
            this.logger.info("Step index ({}), time spend ({}) taking step ({}) out of {} accepted moves.", new Object[]{stepScope.getStepIndex(), localSearchSolverScope.calculateTimeMillisSpend(), nextStep, this.decider.getForager().getAcceptedMovesSize()});
            this.stepDecided(stepScope);
            nextStep.doMove(stepScope.getWorkingMemory());
            localSearchSolverScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                localSearchSolverScope.assertWorkingScore(stepScope.getScore());
            }
            this.stepTaken(stepScope);
            stepScope = this.createNextStepScope(localSearchSolverScope, stepScope);
        }
        this.solvingEnded(localSearchSolverScope);
    }

    private StepScope createNextStepScope(LocalSearchSolverScope localSearchSolverScope, StepScope completedStepScope) {
        if (completedStepScope == null) {
            completedStepScope = new StepScope(localSearchSolverScope);
            completedStepScope.setScore(localSearchSolverScope.getStartingScore());
            completedStepScope.setStepIndex(-1);
            completedStepScope.setTimeGradient(0.0);
        }
        localSearchSolverScope.setLastCompletedStepScope(completedStepScope);
        StepScope stepScope = new StepScope(localSearchSolverScope);
        stepScope.setStepIndex(completedStepScope.getStepIndex() + 1);
        return stepScope;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        localSearchSolverScope.reset();
        if (this.randomSeed != null) {
            this.logger.info("Solving with random seed ({}).", (Object)this.randomSeed);
            localSearchSolverScope.setWorkingRandom(new Random(this.randomSeed));
        } else {
            this.logger.info("Solving with a non-fixed random seed.");
            localSearchSolverScope.setWorkingRandom(new Random());
        }
        if (this.startingSolutionInitializer != null) {
            if (!this.startingSolutionInitializer.isSolutionInitialized(localSearchSolverScope)) {
                this.logger.info("Initializing solution.");
                this.startingSolutionInitializer.initializeSolution(localSearchSolverScope);
            } else {
                this.logger.debug("Solution is already initialized.");
            }
        }
        localSearchSolverScope.setStartingScore(localSearchSolverScope.calculateScoreFromWorkingMemory());
        this.bestSolutionRecaller.solvingStarted(localSearchSolverScope);
        this.termination.solvingStarted(localSearchSolverScope);
        this.decider.solvingStarted(localSearchSolverScope);
    }

    public void beforeDeciding(StepScope stepScope) {
        this.bestSolutionRecaller.beforeDeciding(stepScope);
        this.termination.beforeDeciding(stepScope);
        this.decider.beforeDeciding(stepScope);
    }

    public void stepDecided(StepScope stepScope) {
        this.bestSolutionRecaller.stepDecided(stepScope);
        this.termination.stepDecided(stepScope);
        this.decider.stepDecided(stepScope);
    }

    public void stepTaken(StepScope stepScope) {
        this.bestSolutionRecaller.stepTaken(stepScope);
        this.termination.stepTaken(stepScope);
        this.decider.stepTaken(stepScope);
    }

    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        this.bestSolutionRecaller.solvingEnded(localSearchSolverScope);
        this.termination.solvingEnded(localSearchSolverScope);
        this.decider.solvingEnded(localSearchSolverScope);
        long timeMillisSpend = localSearchSolverScope.calculateTimeMillisSpend();
        long averageCalculateCountPerSecond = localSearchSolverScope.getCalculateCount() * 1000L / timeMillisSpend;
        this.logger.info("Solved at step index ({}) with time spend ({}) for best score ({}) with average calculate count per second ({}).", new Object[]{localSearchSolverScope.getLastCompletedStepScope().getStepIndex(), timeMillisSpend, localSearchSolverScope.getBestScore(), averageCalculateCountPerSecond});
    }
}

