/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.drools.ClassObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.calculator.ScoreCalculator;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.constraint.DoubleConstraintOccurrence;
import org.drools.planner.core.score.constraint.IntConstraintOccurrence;
import org.drools.planner.core.score.constraint.UnweightedConstraintOccurrence;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.solution.Solution;
import org.drools.runtime.ObjectFilter;

public class LocalSearchSolverScope {
    public static final String GLOBAL_SCORE_CALCULATOR_KEY = "scoreCalculator";
    protected RuleBase ruleBase;
    private ScoreDefinition scoreDefinition;
    private long startingSystemTimeMillis;
    private Solution workingSolution;
    private StatefulSession workingMemory;
    private ScoreCalculator workingScoreCalculator;
    private Random workingRandom;
    private Score startingScore;
    private long calculateCount;
    private int bestSolutionStepIndex;
    private Solution bestSolution;
    private Score bestScore;
    private StepScope lastCompletedStepScope;

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public void setStartingSystemTimeMillis(long startingSystemTimeMillis) {
        this.startingSystemTimeMillis = startingSystemTimeMillis;
    }

    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetWorkingMemory();
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public ScoreCalculator getWorkingScoreCalculator() {
        return this.workingScoreCalculator;
    }

    public void setWorkingScoreCalculator(ScoreCalculator workingScoreCalculator) {
        this.workingScoreCalculator = workingScoreCalculator;
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public void setStartingScore(Score startingScore) {
        this.startingScore = startingScore;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public StepScope getLastCompletedStepScope() {
        return this.lastCompletedStepScope;
    }

    public void setLastCompletedStepScope(StepScope lastCompletedStepScope) {
        this.lastCompletedStepScope = lastCompletedStepScope;
    }

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.calculateCount = 0L;
    }

    public Score calculateScoreFromWorkingMemory() {
        this.workingMemory.fireAllRules();
        Score score = this.workingScoreCalculator.calculateScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    public long calculateTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    private void resetWorkingMemory() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
        this.workingMemory = this.ruleBase.newStatefulSession();
        this.workingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)this.workingScoreCalculator);
        for (Object object : this.workingSolution.getFacts()) {
            this.workingMemory.insert(object);
        }
    }

    public void assertWorkingScore(Score presumedScore) {
        StatefulSession tmpWorkingMemory = this.ruleBase.newStatefulSession();
        ScoreCalculator tmpScoreCalculator = this.workingScoreCalculator.clone();
        tmpWorkingMemory.setGlobal(GLOBAL_SCORE_CALCULATOR_KEY, (Object)tmpScoreCalculator);
        for (Object object : this.workingSolution.getFacts()) {
            tmpWorkingMemory.insert(object);
        }
        tmpWorkingMemory.fireAllRules();
        Score realScore = tmpScoreCalculator.calculateScore();
        tmpWorkingMemory.dispose();
        if (!presumedScore.equals(realScore)) {
            throw new IllegalStateException("The presumedScore (" + presumedScore + ") is corrupted because it is not the realScore  (" + realScore + ").\n" + "Presumed workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory) + "Real workingMemory:\n" + this.buildConstraintOccurrenceSummary((WorkingMemory)tmpWorkingMemory));
        }
    }

    public String buildConstraintOccurrenceSummary() {
        return this.buildConstraintOccurrenceSummary((WorkingMemory)this.workingMemory);
    }

    public String buildConstraintOccurrenceSummary(WorkingMemory summaryWorkingMemory) {
        if (summaryWorkingMemory == null) {
            return "  The workingMemory is null.";
        }
        TreeMap<String, Number> scoreTotalMap = new TreeMap<String, Number>();
        Iterator it = summaryWorkingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (it.hasNext()) {
            ConstraintOccurrence occurrence = (ConstraintOccurrence)it.next();
            Number scoreTotalNumber = (Number)scoreTotalMap.get(occurrence.getRuleId());
            if (occurrence instanceof IntConstraintOccurrence) {
                int scoreTotal = scoreTotalNumber == null ? 0 : (Integer)scoreTotalNumber;
                scoreTotalMap.put(occurrence.getRuleId(), scoreTotal += ((IntConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof DoubleConstraintOccurrence) {
                double scoreTotal = scoreTotalNumber == null ? 0.0 : (Double)scoreTotalNumber;
                scoreTotalMap.put(occurrence.getRuleId(), scoreTotal += ((DoubleConstraintOccurrence)occurrence).getWeight());
                continue;
            }
            if (occurrence instanceof UnweightedConstraintOccurrence) {
                int scoreTotal = scoreTotalNumber == null ? 0 : (Integer)scoreTotalNumber;
                scoreTotalMap.put(occurrence.getRuleId(), ++scoreTotal);
                continue;
            }
            throw new IllegalStateException("Cannot determine occurrenceScore of ConstraintOccurrence class: " + occurrence.getClass());
        }
        StringBuilder summary = new StringBuilder();
        for (Map.Entry scoreTotalEntry : scoreTotalMap.entrySet()) {
            summary.append("  Score rule (").append((String)scoreTotalEntry.getKey()).append(") has score total (").append(scoreTotalEntry.getValue()).append(").\n");
        }
        return summary.toString();
    }
}

