/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.bestsolution;

import org.drools.planner.core.event.SolverEventSupport;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolverAware;
import org.drools.planner.core.localsearch.LocalSearchSolverLifecycleListener;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestSolutionRecaller
implements LocalSearchSolverAware,
LocalSearchSolverLifecycleListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolver localSearchSolver;
    protected SolverEventSupport solverEventSupport;

    public void setLocalSearchSolver(LocalSearchSolver localSearchSolver) {
        this.localSearchSolver = localSearchSolver;
    }

    public void setSolverEventSupport(SolverEventSupport solverEventSupport) {
        this.solverEventSupport = solverEventSupport;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        Score initialScore = localSearchSolverScope.getStartingScore();
        this.logger.info("Initialization time spend ({}) for score ({}). Updating best solution and best score.", (Object)localSearchSolverScope.calculateTimeMillisSpend(), (Object)initialScore);
        localSearchSolverScope.setBestSolutionStepIndex(-1);
        localSearchSolverScope.setBestSolution(localSearchSolverScope.getWorkingSolution().cloneSolution());
        localSearchSolverScope.setBestScore(initialScore);
    }

    public void beforeDeciding(StepScope stepScope) {
    }

    public void stepDecided(StepScope stepScope) {
    }

    public void stepTaken(StepScope stepScope) {
        Score bestScore;
        LocalSearchSolverScope localSearchSolverScope = stepScope.getLocalSearchSolverScope();
        Score newScore = stepScope.getScore();
        if (newScore.compareTo(bestScore = localSearchSolverScope.getBestScore()) > 0) {
            this.logger.info("New score ({}) is better then last best score ({}). Updating best solution and best score.", (Object)newScore, (Object)bestScore);
            localSearchSolverScope.setBestSolutionStepIndex(stepScope.getStepIndex());
            Solution newBestSolution = stepScope.createOrGetClonedSolution();
            localSearchSolverScope.setBestSolution(newBestSolution);
            localSearchSolverScope.setBestScore(newBestSolution.getScore());
            this.solverEventSupport.fireBestSolutionChanged(newBestSolution);
        } else {
            this.logger.info("New score ({}) is not better then last best score ({}).", (Object)newScore, (Object)bestScore);
        }
    }

    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
    }
}

