/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider;

import java.util.Iterator;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.LocalSearchSolver;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolver localSearchSolver;
    protected DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected Selector selector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setLocalSearchSolver(LocalSearchSolver localSearchSolver) {
        this.localSearchSolver = localSearchSolver;
    }

    public DeciderScoreComparatorFactory getDeciderScoreComparator() {
        return this.deciderScoreComparatorFactory;
    }

    public void setDeciderScoreComparator(DeciderScoreComparatorFactory deciderScoreComparator) {
        this.deciderScoreComparatorFactory = deciderScoreComparator;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
        selector.setDecider(this);
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        this.deciderScoreComparatorFactory.solvingStarted(localSearchSolverScope);
        this.selector.solvingStarted(localSearchSolverScope);
        this.acceptor.solvingStarted(localSearchSolverScope);
        this.forager.solvingStarted(localSearchSolverScope);
    }

    public void beforeDeciding(StepScope stepScope) {
        this.deciderScoreComparatorFactory.beforeDeciding(stepScope);
        stepScope.setDeciderScoreComparator(this.deciderScoreComparatorFactory.createDeciderScoreComparator());
        this.selector.beforeDeciding(stepScope);
        this.acceptor.beforeDeciding(stepScope);
        this.forager.beforeDeciding(stepScope);
    }

    public void decideNextStep(StepScope stepScope) {
        MoveScope pickedMoveScope;
        WorkingMemory workingMemory = stepScope.getWorkingMemory();
        Iterator<Move> moveIterator = this.selector.moveIterator(stepScope);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            MoveScope moveScope = new MoveScope(stepScope);
            moveScope.setMove(move);
            if (move.isMoveDoable(workingMemory)) {
                this.doMove(moveScope);
                if (!this.forager.isQuitEarly()) continue;
                break;
            }
            this.logger.debug("    Move ({}) ignored because it is not doable.", (Object)move);
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            stepScope.setUndoStep(step.createUndoMove(workingMemory));
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(MoveScope moveScope) {
        Score lastCompletedStepScore;
        Score undoScore;
        WorkingMemory workingMemory = moveScope.getWorkingMemory();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(workingMemory);
        moveScope.setUndoMove(undoMove);
        move.doMove(workingMemory);
        this.processMove(moveScope);
        undoMove.doMove(workingMemory);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = moveScope.getStepScope().getLocalSearchSolverScope().calculateScoreFromWorkingMemory()).equals(lastCompletedStepScore = moveScope.getStepScope().getLocalSearchSolverScope().getLastCompletedStepScope().getScore())) {
            throw new IllegalStateException("Corrupted undo move (" + undoMove + ") received from move (" + move + ").\n" + "Unequal lastCompletedStepScore (" + lastCompletedStepScore + ") and undoScore (" + undoScore + ").\n" + moveScope.getStepScope().getLocalSearchSolverScope().buildConstraintOccurrenceSummary());
        }
        this.logger.debug("    Move ({}) with score ({}) and acceptChance ({}).", new Object[]{moveScope.getMove(), moveScope.getScore(), moveScope.getAcceptChance()});
    }

    private void processMove(MoveScope moveScope) {
        Score score = moveScope.getStepScope().getLocalSearchSolverScope().calculateScoreFromWorkingMemory();
        moveScope.setScore(score);
        double acceptChance = this.acceptor.calculateAcceptChance(moveScope);
        moveScope.setAcceptChance(acceptChance);
        this.forager.addMove(moveScope);
    }

    public void stepDecided(StepScope stepScope) {
        this.deciderScoreComparatorFactory.stepDecided(stepScope);
        this.selector.stepDecided(stepScope);
        this.acceptor.stepDecided(stepScope);
        this.forager.stepDecided(stepScope);
    }

    public void stepTaken(StepScope stepScope) {
        this.deciderScoreComparatorFactory.stepTaken(stepScope);
        this.selector.stepTaken(stepScope);
        this.acceptor.stepTaken(stepScope);
        this.forager.stepTaken(stepScope);
    }

    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        this.deciderScoreComparatorFactory.solvingEnded(localSearchSolverScope);
        this.selector.solvingEnded(localSearchSolverScope);
        this.acceptor.solvingEnded(localSearchSolverScope);
        this.forager.solvingEnded(localSearchSolverScope);
    }
}

