/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor;

import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAcceptor
extends AbstractAcceptor {
    protected List<Acceptor> acceptorList;

    public void setAcceptorList(List<Acceptor> acceptorList) {
        this.acceptorList = acceptorList;
    }

    @Override
    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingStarted(localSearchSolverScope);
        }
    }

    @Override
    public void beforeDeciding(StepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.beforeDeciding(stepScope);
        }
    }

    @Override
    public double calculateAcceptChance(MoveScope moveScope) {
        double acceptChance = 1.0;
        for (Acceptor acceptor : this.acceptorList) {
            acceptChance *= acceptor.calculateAcceptChance(moveScope);
        }
        return acceptChance;
    }

    @Override
    public void stepDecided(StepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepDecided(stepScope);
        }
    }

    @Override
    public void stepTaken(StepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepTaken(stepScope);
        }
    }

    @Override
    public void solvingEnded(LocalSearchSolverScope localSearchSolverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingEnded(localSearchSolverScope);
        }
    }
}

