/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.greatdeluge;

import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class GreatDelugeAcceptor
extends AbstractAcceptor {
    protected final double waterLevelUpperBoundRate;
    protected final double waterRisingRate;
    protected Score waterLevelScore = null;

    public GreatDelugeAcceptor(double waterLevelUpperBoundRate, double waterRisingRate) {
        this.waterLevelUpperBoundRate = waterLevelUpperBoundRate;
        this.waterRisingRate = waterRisingRate;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        if (this.waterLevelUpperBoundRate < 1.0) {
            throw new IllegalArgumentException("The greatDelugeWaterLevelUpperBoundRate (" + this.waterLevelUpperBoundRate + ") should be 1.0 or higher.");
        }
        if (this.waterRisingRate <= 0.0 || this.waterRisingRate >= 1.0) {
            throw new IllegalArgumentException("The greatDelugeWaterRisingRate (" + this.waterRisingRate + ") should be between 0.0 and 1.0 (preferably very close to 0.0).");
        }
        this.waterLevelScore = localSearchSolverScope.getBestScore().multiply(this.waterLevelUpperBoundRate);
        Object perfectMaximumScore = localSearchSolverScope.getScoreDefinition().getPerfectMaximumScore();
        if (this.waterLevelScore.compareTo(perfectMaximumScore) > 0) {
            throw new IllegalArgumentException("The waterLevelScore (" + this.waterLevelScore + ") should not be higher than the perfectMaximumScore(" + perfectMaximumScore + ").");
        }
    }

    public double calculateAcceptChance(MoveScope moveScope) {
        if (moveScope.getScore().compareTo(this.waterLevelScore) >= 0) {
            return 1.0;
        }
        return 0.0;
    }

    public void stepTaken(StepScope stepScope) {
        if (stepScope.getStepIndex() == stepScope.getLocalSearchSolverScope().getBestSolutionStepIndex()) {
            this.waterLevelScore = stepScope.getLocalSearchSolverScope().getBestScore().multiply(this.waterLevelUpperBoundRate);
        } else {
            Score perfectMaximumScore = stepScope.getLocalSearchSolverScope().getScoreDefinition().getPerfectMaximumScore();
            Object waterLevelAugend = perfectMaximumScore.subtract((Score)this.waterLevelScore).multiply(this.waterRisingRate);
            this.waterLevelScore = this.waterLevelScore.add(waterLevelAugend);
        }
    }
}

