/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class LegacySimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected double startingTemperature = -1.0;
    protected double temperatureSurvival = 0.997;
    protected double temperature;

    public void setStartingTemperature(double startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void setTemperatureSurvival(double temperatureSurvival) {
        this.temperatureSurvival = temperatureSurvival;
    }

    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        if (this.startingTemperature <= 0.0) {
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot be negative or zero.");
        }
        if (this.temperatureSurvival <= 0.0) {
            throw new IllegalArgumentException("The temperatureSurvival (" + this.temperatureSurvival + ") cannot be negative or zero.");
        }
        this.temperature = this.startingTemperature;
    }

    public double calculateAcceptChance(MoveScope moveScope) {
        LocalSearchSolverScope localSearchSolverScope = moveScope.getStepScope().getLocalSearchSolverScope();
        Score lastStepScore = localSearchSolverScope.getLastCompletedStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) > 0) {
            return 1.0;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        Double diff = localSearchSolverScope.getScoreDefinition().translateScoreToGraphValue(scoreDifference);
        if (diff == null) {
            return 0.0;
        }
        double acceptChance = Math.exp(-diff.doubleValue() / this.temperature);
        if (moveScope.getWorkingRandom().nextDouble() < acceptChance) {
            return 1.0;
        }
        return 0.0;
    }

    public void stepTaken(StepScope stepScope) {
        super.stepTaken(stepScope);
        this.temperature *= this.temperatureSurvival;
    }
}

