/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.deciderscorecomparator;

import java.util.Comparator;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.localsearch.StepScope;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.AbstractDeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.HardPenaltyDeciderScoreComparator;
import org.drools.planner.core.score.HardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.comparator.NaturalScoreComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftingHardPenaltyDeciderScoreComparatorFactory
extends AbstractDeciderScoreComparatorFactory {
    private int hardScoreActivationThreshold = 0;
    private int successiveNoHardChangeMinimum = 2;
    private int successiveNoHardChangeMaximum = 20;
    private double successiveNoHardChangeRepetitionMultiplicand = 20.0;
    private double hardWeightSurvivalRatio = 0.8;
    private int startingHardWeight = 1000;
    private int successiveNoHardScoreChange;
    private boolean shiftingPenaltyActive;
    private int hardWeight;
    private Comparator<Score> naturalDeciderScoreComparator = new NaturalScoreComparator();

    public void setHardScoreActivationThreshold(int hardScoreActivationThreshold) {
        this.hardScoreActivationThreshold = hardScoreActivationThreshold;
    }

    public void setSuccessiveNoHardChangeMinimum(int successiveNoHardChangeMinimum) {
        this.successiveNoHardChangeMinimum = successiveNoHardChangeMinimum;
    }

    public void setSuccessiveNoHardChangeMaximum(int successiveNoHardChangeMaximum) {
        this.successiveNoHardChangeMaximum = successiveNoHardChangeMaximum;
    }

    public void setSuccessiveNoHardChangeRepetitionMultiplicand(double successiveNoHardChangeRepetitionMultiplicand) {
        this.successiveNoHardChangeRepetitionMultiplicand = successiveNoHardChangeRepetitionMultiplicand;
    }

    public void setHardWeightSurvivalRatio(double hardWeightSurvivalRatio) {
        this.hardWeightSurvivalRatio = hardWeightSurvivalRatio;
    }

    public void setStartingHardWeight(int startingHardWeight) {
        this.startingHardWeight = startingHardWeight;
    }

    @Override
    public void solvingStarted(LocalSearchSolverScope localSearchSolverScope) {
        this.successiveNoHardScoreChange = 0;
        this.shiftingPenaltyActive = false;
    }

    @Override
    public void stepTaken(StepScope stepScope) {
        if (stepScope.getStepIndex() == stepScope.getLocalSearchSolverScope().getBestSolutionStepIndex()) {
            this.successiveNoHardScoreChange = 0;
            this.shiftingPenaltyActive = false;
        } else {
            HardAndSoftScore lastStepScore = (HardAndSoftScore)stepScope.getLocalSearchSolverScope().getLastCompletedStepScope().getScore();
            HardAndSoftScore stepScore = (HardAndSoftScore)stepScope.getScore();
            if (stepScore.getHardScore() >= this.hardScoreActivationThreshold && lastStepScore.getHardScore() == stepScore.getHardScore()) {
                ++this.successiveNoHardScoreChange;
            } else {
                --this.successiveNoHardScoreChange;
                if (this.successiveNoHardScoreChange < 0) {
                    this.successiveNoHardScoreChange = 0;
                }
            }
            int min = this.successiveNoHardChangeMinimum;
            int max = this.successiveNoHardChangeMaximum;
            while (true) {
                if (this.successiveNoHardScoreChange < min) {
                    this.shiftingPenaltyActive = false;
                    break;
                }
                if (this.successiveNoHardScoreChange <= max) {
                    this.shiftingPenaltyActive = true;
                    if (this.successiveNoHardScoreChange == min) {
                        this.hardWeight = this.startingHardWeight;
                        break;
                    }
                    this.hardWeight = (int)Math.round((double)this.hardWeight * this.hardWeightSurvivalRatio);
                    break;
                }
                min = (int)Math.round((double)min * this.successiveNoHardChangeRepetitionMultiplicand);
                max = (int)Math.round((double)max * this.successiveNoHardChangeRepetitionMultiplicand);
            }
        }
    }

    @Override
    public Comparator<Score> createDeciderScoreComparator() {
        if (this.shiftingPenaltyActive) {
            return new HardPenaltyDeciderScoreComparator(this.hardWeight);
        }
        return this.naturalDeciderScoreComparator;
    }
}

